/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.config.model.ConfigurationItem;
import com.amazonaws.services.config.model.Relationship;
import com.amazonaws.services.config.model.transform.RelationshipJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class ConfigurationItemJsonMarshaller {
    private static ConfigurationItemJsonMarshaller instance;

    public void marshall(ConfigurationItem configurationItem, JSONWriter jsonWriter) {
        if (configurationItem == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList relationshipsList;
            SdkInternalList relatedEventsList;
            Map<String, String> tagsMap;
            jsonWriter.object();
            if (configurationItem.getVersion() != null) {
                jsonWriter.key("version").value(configurationItem.getVersion());
            }
            if (configurationItem.getAccountId() != null) {
                jsonWriter.key("accountId").value(configurationItem.getAccountId());
            }
            if (configurationItem.getConfigurationItemCaptureTime() != null) {
                jsonWriter.key("configurationItemCaptureTime").value(configurationItem.getConfigurationItemCaptureTime());
            }
            if (configurationItem.getConfigurationItemStatus() != null) {
                jsonWriter.key("configurationItemStatus").value(configurationItem.getConfigurationItemStatus());
            }
            if (configurationItem.getConfigurationStateId() != null) {
                jsonWriter.key("configurationStateId").value(configurationItem.getConfigurationStateId());
            }
            if (configurationItem.getConfigurationItemMD5Hash() != null) {
                jsonWriter.key("configurationItemMD5Hash").value(configurationItem.getConfigurationItemMD5Hash());
            }
            if (configurationItem.getArn() != null) {
                jsonWriter.key("arn").value(configurationItem.getArn());
            }
            if (configurationItem.getResourceType() != null) {
                jsonWriter.key("resourceType").value(configurationItem.getResourceType());
            }
            if (configurationItem.getResourceId() != null) {
                jsonWriter.key("resourceId").value(configurationItem.getResourceId());
            }
            if (configurationItem.getResourceName() != null) {
                jsonWriter.key("resourceName").value(configurationItem.getResourceName());
            }
            if (configurationItem.getAwsRegion() != null) {
                jsonWriter.key("awsRegion").value(configurationItem.getAwsRegion());
            }
            if (configurationItem.getAvailabilityZone() != null) {
                jsonWriter.key("availabilityZone").value(configurationItem.getAvailabilityZone());
            }
            if (configurationItem.getResourceCreationTime() != null) {
                jsonWriter.key("resourceCreationTime").value(configurationItem.getResourceCreationTime());
            }
            if ((tagsMap = configurationItem.getTags()) != null) {
                jsonWriter.key("tags");
                jsonWriter.object();
                for (Map.Entry<String, String> tagsMapValue : tagsMap.entrySet()) {
                    if (tagsMapValue.getValue() == null) continue;
                    jsonWriter.key(tagsMapValue.getKey());
                    jsonWriter.value(tagsMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (!(relatedEventsList = (SdkInternalList)configurationItem.getRelatedEvents()).isEmpty() || !relatedEventsList.isAutoConstruct()) {
                jsonWriter.key("relatedEvents");
                jsonWriter.array();
                for (String relatedEventsListValue : relatedEventsList) {
                    if (relatedEventsListValue == null) continue;
                    jsonWriter.value(relatedEventsListValue);
                }
                jsonWriter.endArray();
            }
            if (!(relationshipsList = (SdkInternalList)configurationItem.getRelationships()).isEmpty() || !relationshipsList.isAutoConstruct()) {
                jsonWriter.key("relationships");
                jsonWriter.array();
                for (Relationship relationshipsListValue : relationshipsList) {
                    if (relationshipsListValue == null) continue;
                    RelationshipJsonMarshaller.getInstance().marshall(relationshipsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (configurationItem.getConfiguration() != null) {
                jsonWriter.key("configuration").value(configurationItem.getConfiguration());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ConfigurationItemJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ConfigurationItemJsonMarshaller();
        }
        return instance;
    }
}

