/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.rds.model.CharacterSet;
import com.amazonaws.services.rds.model.UpgradeTarget;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DBEngineVersion
implements Serializable,
Cloneable {
    private String engine;
    private String engineVersion;
    private String dBParameterGroupFamily;
    private String dBEngineDescription;
    private String dBEngineVersionDescription;
    private CharacterSet defaultCharacterSet;
    private ListWithAutoConstructFlag<CharacterSet> supportedCharacterSets;
    private ListWithAutoConstructFlag<UpgradeTarget> validUpgradeTarget;

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public DBEngineVersion withEngine(String engine) {
        this.engine = engine;
        return this;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public DBEngineVersion withEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
        return this;
    }

    public String getDBParameterGroupFamily() {
        return this.dBParameterGroupFamily;
    }

    public void setDBParameterGroupFamily(String dBParameterGroupFamily) {
        this.dBParameterGroupFamily = dBParameterGroupFamily;
    }

    public DBEngineVersion withDBParameterGroupFamily(String dBParameterGroupFamily) {
        this.dBParameterGroupFamily = dBParameterGroupFamily;
        return this;
    }

    public String getDBEngineDescription() {
        return this.dBEngineDescription;
    }

    public void setDBEngineDescription(String dBEngineDescription) {
        this.dBEngineDescription = dBEngineDescription;
    }

    public DBEngineVersion withDBEngineDescription(String dBEngineDescription) {
        this.dBEngineDescription = dBEngineDescription;
        return this;
    }

    public String getDBEngineVersionDescription() {
        return this.dBEngineVersionDescription;
    }

    public void setDBEngineVersionDescription(String dBEngineVersionDescription) {
        this.dBEngineVersionDescription = dBEngineVersionDescription;
    }

    public DBEngineVersion withDBEngineVersionDescription(String dBEngineVersionDescription) {
        this.dBEngineVersionDescription = dBEngineVersionDescription;
        return this;
    }

    public CharacterSet getDefaultCharacterSet() {
        return this.defaultCharacterSet;
    }

    public void setDefaultCharacterSet(CharacterSet defaultCharacterSet) {
        this.defaultCharacterSet = defaultCharacterSet;
    }

    public DBEngineVersion withDefaultCharacterSet(CharacterSet defaultCharacterSet) {
        this.defaultCharacterSet = defaultCharacterSet;
        return this;
    }

    public List<CharacterSet> getSupportedCharacterSets() {
        if (this.supportedCharacterSets == null) {
            this.supportedCharacterSets = new ListWithAutoConstructFlag();
            this.supportedCharacterSets.setAutoConstruct(true);
        }
        return this.supportedCharacterSets;
    }

    public void setSupportedCharacterSets(Collection<CharacterSet> supportedCharacterSets) {
        if (supportedCharacterSets == null) {
            this.supportedCharacterSets = null;
            return;
        }
        ListWithAutoConstructFlag supportedCharacterSetsCopy = new ListWithAutoConstructFlag(supportedCharacterSets.size());
        supportedCharacterSetsCopy.addAll(supportedCharacterSets);
        this.supportedCharacterSets = supportedCharacterSetsCopy;
    }

    public DBEngineVersion withSupportedCharacterSets(CharacterSet ... supportedCharacterSets) {
        if (this.getSupportedCharacterSets() == null) {
            this.setSupportedCharacterSets(new ArrayList<CharacterSet>(supportedCharacterSets.length));
        }
        for (CharacterSet value : supportedCharacterSets) {
            this.getSupportedCharacterSets().add(value);
        }
        return this;
    }

    public DBEngineVersion withSupportedCharacterSets(Collection<CharacterSet> supportedCharacterSets) {
        if (supportedCharacterSets == null) {
            this.supportedCharacterSets = null;
        } else {
            ListWithAutoConstructFlag supportedCharacterSetsCopy = new ListWithAutoConstructFlag(supportedCharacterSets.size());
            supportedCharacterSetsCopy.addAll(supportedCharacterSets);
            this.supportedCharacterSets = supportedCharacterSetsCopy;
        }
        return this;
    }

    public List<UpgradeTarget> getValidUpgradeTarget() {
        if (this.validUpgradeTarget == null) {
            this.validUpgradeTarget = new ListWithAutoConstructFlag();
            this.validUpgradeTarget.setAutoConstruct(true);
        }
        return this.validUpgradeTarget;
    }

    public void setValidUpgradeTarget(Collection<UpgradeTarget> validUpgradeTarget) {
        if (validUpgradeTarget == null) {
            this.validUpgradeTarget = null;
            return;
        }
        ListWithAutoConstructFlag validUpgradeTargetCopy = new ListWithAutoConstructFlag(validUpgradeTarget.size());
        validUpgradeTargetCopy.addAll(validUpgradeTarget);
        this.validUpgradeTarget = validUpgradeTargetCopy;
    }

    public DBEngineVersion withValidUpgradeTarget(UpgradeTarget ... validUpgradeTarget) {
        if (this.getValidUpgradeTarget() == null) {
            this.setValidUpgradeTarget(new ArrayList<UpgradeTarget>(validUpgradeTarget.length));
        }
        for (UpgradeTarget value : validUpgradeTarget) {
            this.getValidUpgradeTarget().add(value);
        }
        return this;
    }

    public DBEngineVersion withValidUpgradeTarget(Collection<UpgradeTarget> validUpgradeTarget) {
        if (validUpgradeTarget == null) {
            this.validUpgradeTarget = null;
        } else {
            ListWithAutoConstructFlag validUpgradeTargetCopy = new ListWithAutoConstructFlag(validUpgradeTarget.size());
            validUpgradeTargetCopy.addAll(validUpgradeTarget);
            this.validUpgradeTarget = validUpgradeTargetCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEngine() != null) {
            sb.append("Engine: " + this.getEngine() + ",");
        }
        if (this.getEngineVersion() != null) {
            sb.append("EngineVersion: " + this.getEngineVersion() + ",");
        }
        if (this.getDBParameterGroupFamily() != null) {
            sb.append("DBParameterGroupFamily: " + this.getDBParameterGroupFamily() + ",");
        }
        if (this.getDBEngineDescription() != null) {
            sb.append("DBEngineDescription: " + this.getDBEngineDescription() + ",");
        }
        if (this.getDBEngineVersionDescription() != null) {
            sb.append("DBEngineVersionDescription: " + this.getDBEngineVersionDescription() + ",");
        }
        if (this.getDefaultCharacterSet() != null) {
            sb.append("DefaultCharacterSet: " + this.getDefaultCharacterSet() + ",");
        }
        if (this.getSupportedCharacterSets() != null) {
            sb.append("SupportedCharacterSets: " + this.getSupportedCharacterSets() + ",");
        }
        if (this.getValidUpgradeTarget() != null) {
            sb.append("ValidUpgradeTarget: " + this.getValidUpgradeTarget());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEngine() == null ? 0 : this.getEngine().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getDBParameterGroupFamily() == null ? 0 : this.getDBParameterGroupFamily().hashCode());
        hashCode = 31 * hashCode + (this.getDBEngineDescription() == null ? 0 : this.getDBEngineDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDBEngineVersionDescription() == null ? 0 : this.getDBEngineVersionDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultCharacterSet() == null ? 0 : this.getDefaultCharacterSet().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedCharacterSets() == null ? 0 : this.getSupportedCharacterSets().hashCode());
        hashCode = 31 * hashCode + (this.getValidUpgradeTarget() == null ? 0 : this.getValidUpgradeTarget().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBEngineVersion)) {
            return false;
        }
        DBEngineVersion other = (DBEngineVersion)obj;
        if (other.getEngine() == null ^ this.getEngine() == null) {
            return false;
        }
        if (other.getEngine() != null && !other.getEngine().equals(this.getEngine())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.getDBParameterGroupFamily() == null ^ this.getDBParameterGroupFamily() == null) {
            return false;
        }
        if (other.getDBParameterGroupFamily() != null && !other.getDBParameterGroupFamily().equals(this.getDBParameterGroupFamily())) {
            return false;
        }
        if (other.getDBEngineDescription() == null ^ this.getDBEngineDescription() == null) {
            return false;
        }
        if (other.getDBEngineDescription() != null && !other.getDBEngineDescription().equals(this.getDBEngineDescription())) {
            return false;
        }
        if (other.getDBEngineVersionDescription() == null ^ this.getDBEngineVersionDescription() == null) {
            return false;
        }
        if (other.getDBEngineVersionDescription() != null && !other.getDBEngineVersionDescription().equals(this.getDBEngineVersionDescription())) {
            return false;
        }
        if (other.getDefaultCharacterSet() == null ^ this.getDefaultCharacterSet() == null) {
            return false;
        }
        if (other.getDefaultCharacterSet() != null && !other.getDefaultCharacterSet().equals(this.getDefaultCharacterSet())) {
            return false;
        }
        if (other.getSupportedCharacterSets() == null ^ this.getSupportedCharacterSets() == null) {
            return false;
        }
        if (other.getSupportedCharacterSets() != null && !other.getSupportedCharacterSets().equals(this.getSupportedCharacterSets())) {
            return false;
        }
        if (other.getValidUpgradeTarget() == null ^ this.getValidUpgradeTarget() == null) {
            return false;
        }
        return other.getValidUpgradeTarget() == null || other.getValidUpgradeTarget().equals(this.getValidUpgradeTarget());
    }

    public DBEngineVersion clone() {
        try {
            return (DBEngineVersion)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

