/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.opsworks.model.DescribeElasticIpsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DescribeElasticIpsRequestMarshaller
implements Marshaller<Request<DescribeElasticIpsRequest>, DescribeElasticIpsRequest> {
    @Override
    public Request<DescribeElasticIpsRequest> marshall(DescribeElasticIpsRequest describeElasticIpsRequest) {
        if (describeElasticIpsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeElasticIpsRequest> request = new DefaultRequest<DescribeElasticIpsRequest>(describeElasticIpsRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.DescribeElasticIps");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList ipsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (describeElasticIpsRequest.getInstanceId() != null) {
                jsonWriter.key("InstanceId").value(describeElasticIpsRequest.getInstanceId());
            }
            if (describeElasticIpsRequest.getStackId() != null) {
                jsonWriter.key("StackId").value(describeElasticIpsRequest.getStackId());
            }
            if (!(ipsList = (SdkInternalList)describeElasticIpsRequest.getIps()).isEmpty() || !ipsList.isAutoConstruct()) {
                jsonWriter.key("Ips");
                jsonWriter.array();
                for (String ipsListValue : ipsList) {
                    if (ipsListValue == null) continue;
                    jsonWriter.value(ipsListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

