/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotdata;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.PredefinedClientConfigurations;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.iotdata.AWSIotDataAsync;
import com.amazonaws.services.iotdata.AWSIotDataClient;
import com.amazonaws.services.iotdata.model.DeleteThingShadowRequest;
import com.amazonaws.services.iotdata.model.DeleteThingShadowResult;
import com.amazonaws.services.iotdata.model.GetThingShadowRequest;
import com.amazonaws.services.iotdata.model.GetThingShadowResult;
import com.amazonaws.services.iotdata.model.PublishRequest;
import com.amazonaws.services.iotdata.model.UpdateThingShadowRequest;
import com.amazonaws.services.iotdata.model.UpdateThingShadowResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AWSIotDataAsyncClient
extends AWSIotDataClient
implements AWSIotDataAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AWSIotDataAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AWSIotDataAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSIotDataAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSIotDataAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, PredefinedClientConfigurations.defaultConfig(), executorService);
    }

    public AWSIotDataAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSIotDataAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSIotDataAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSIotDataAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, PredefinedClientConfigurations.defaultConfig(), executorService);
    }

    public AWSIotDataAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DeleteThingShadowResult> deleteThingShadowAsync(DeleteThingShadowRequest request) {
        return this.deleteThingShadowAsync(request, null);
    }

    @Override
    public Future<DeleteThingShadowResult> deleteThingShadowAsync(final DeleteThingShadowRequest request, final AsyncHandler<DeleteThingShadowRequest, DeleteThingShadowResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteThingShadowResult>(){

            @Override
            public DeleteThingShadowResult call() throws Exception {
                DeleteThingShadowResult result;
                try {
                    result = AWSIotDataAsyncClient.this.deleteThingShadow(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetThingShadowResult> getThingShadowAsync(GetThingShadowRequest request) {
        return this.getThingShadowAsync(request, null);
    }

    @Override
    public Future<GetThingShadowResult> getThingShadowAsync(final GetThingShadowRequest request, final AsyncHandler<GetThingShadowRequest, GetThingShadowResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetThingShadowResult>(){

            @Override
            public GetThingShadowResult call() throws Exception {
                GetThingShadowResult result;
                try {
                    result = AWSIotDataAsyncClient.this.getThingShadow(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> publishAsync(PublishRequest request) {
        return this.publishAsync(request, null);
    }

    @Override
    public Future<Void> publishAsync(final PublishRequest request, final AsyncHandler<PublishRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSIotDataAsyncClient.this.publish(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateThingShadowResult> updateThingShadowAsync(UpdateThingShadowRequest request) {
        return this.updateThingShadowAsync(request, null);
    }

    @Override
    public Future<UpdateThingShadowResult> updateThingShadowAsync(final UpdateThingShadowRequest request, final AsyncHandler<UpdateThingShadowRequest, UpdateThingShadowResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateThingShadowResult>(){

            @Override
            public UpdateThingShadowResult call() throws Exception {
                UpdateThingShadowResult result;
                try {
                    result = AWSIotDataAsyncClient.this.updateThingShadow(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

