/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elastictranscoder.model.Preset;
import com.amazonaws.services.elastictranscoder.model.transform.AudioParametersJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ThumbnailsJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.VideoParametersJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class PresetJsonMarshaller {
    private static PresetJsonMarshaller instance;

    public void marshall(Preset preset, JSONWriter jsonWriter) {
        if (preset == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (preset.getId() != null) {
                jsonWriter.key("Id").value(preset.getId());
            }
            if (preset.getArn() != null) {
                jsonWriter.key("Arn").value(preset.getArn());
            }
            if (preset.getName() != null) {
                jsonWriter.key("Name").value(preset.getName());
            }
            if (preset.getDescription() != null) {
                jsonWriter.key("Description").value(preset.getDescription());
            }
            if (preset.getContainer() != null) {
                jsonWriter.key("Container").value(preset.getContainer());
            }
            if (preset.getAudio() != null) {
                jsonWriter.key("Audio");
                AudioParametersJsonMarshaller.getInstance().marshall(preset.getAudio(), jsonWriter);
            }
            if (preset.getVideo() != null) {
                jsonWriter.key("Video");
                VideoParametersJsonMarshaller.getInstance().marshall(preset.getVideo(), jsonWriter);
            }
            if (preset.getThumbnails() != null) {
                jsonWriter.key("Thumbnails");
                ThumbnailsJsonMarshaller.getInstance().marshall(preset.getThumbnails(), jsonWriter);
            }
            if (preset.getType() != null) {
                jsonWriter.key("Type").value(preset.getType());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PresetJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PresetJsonMarshaller();
        }
        return instance;
    }
}

