/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticfilesystem.model.DescribeTagsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DescribeTagsRequestMarshaller
implements Marshaller<Request<DescribeTagsRequest>, DescribeTagsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<DescribeTagsRequest> marshall(DescribeTagsRequest describeTagsRequest) {
        String marker;
        String maxItems;
        if (describeTagsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeTagsRequest> request = new DefaultRequest<DescribeTagsRequest>(describeTagsRequest, "AmazonElasticFileSystem");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2015-02-01/tags/{FileSystemId}/";
        uriResourcePath = uriResourcePath.replace("{FileSystemId}", describeTagsRequest.getFileSystemId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(describeTagsRequest.getFileSystemId()));
        request.setResourcePath(uriResourcePath);
        String string = maxItems = describeTagsRequest.getMaxItems() == null ? null : StringUtils.fromInteger(describeTagsRequest.getMaxItems());
        if (maxItems != null) {
            request.addParameter("MaxItems", maxItems);
        }
        String string2 = marker = describeTagsRequest.getMarker() == null ? null : StringUtils.fromString(describeTagsRequest.getMarker());
        if (marker != null) {
            request.addParameter("Marker", marker);
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

