/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeScheduledInstanceAvailabilityRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.ScheduledInstanceRecurrenceRequest;
import com.amazonaws.services.ec2.model.SlotDateTimeRangeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeScheduledInstanceAvailabilityRequestMarshaller
implements Marshaller<Request<DescribeScheduledInstanceAvailabilityRequest>, DescribeScheduledInstanceAvailabilityRequest> {
    @Override
    public Request<DescribeScheduledInstanceAvailabilityRequest> marshall(DescribeScheduledInstanceAvailabilityRequest describeScheduledInstanceAvailabilityRequest) {
        SlotDateTimeRangeRequest slotDateTimeRangeRequestFirstSlotStartTimeRange;
        if (describeScheduledInstanceAvailabilityRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeScheduledInstanceAvailabilityRequest> request = new DefaultRequest<DescribeScheduledInstanceAvailabilityRequest>(describeScheduledInstanceAvailabilityRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeScheduledInstanceAvailability");
        request.addParameter("Version", "2015-10-01");
        ScheduledInstanceRecurrenceRequest scheduledInstanceRecurrenceRequestRecurrence = describeScheduledInstanceAvailabilityRequest.getRecurrence();
        if (scheduledInstanceRecurrenceRequestRecurrence != null) {
            if (scheduledInstanceRecurrenceRequestRecurrence.getFrequency() != null) {
                request.addParameter("Recurrence.Frequency", StringUtils.fromString(scheduledInstanceRecurrenceRequestRecurrence.getFrequency()));
            }
            if (scheduledInstanceRecurrenceRequestRecurrence.getInterval() != null) {
                request.addParameter("Recurrence.Interval", StringUtils.fromInteger(scheduledInstanceRecurrenceRequestRecurrence.getInterval()));
            }
            List<Integer> occurrenceDaysList = scheduledInstanceRecurrenceRequestRecurrence.getOccurrenceDays();
            int occurrenceDaysListIndex = 1;
            for (Integer occurrenceDaysListValue : occurrenceDaysList) {
                if (occurrenceDaysListValue != null) {
                    request.addParameter("Recurrence.OccurrenceDay." + occurrenceDaysListIndex, StringUtils.fromInteger(occurrenceDaysListValue));
                }
                ++occurrenceDaysListIndex;
            }
            if (scheduledInstanceRecurrenceRequestRecurrence.isOccurrenceRelativeToEnd() != null) {
                request.addParameter("Recurrence.OccurrenceRelativeToEnd", StringUtils.fromBoolean(scheduledInstanceRecurrenceRequestRecurrence.isOccurrenceRelativeToEnd()));
            }
            if (scheduledInstanceRecurrenceRequestRecurrence.getOccurrenceUnit() != null) {
                request.addParameter("Recurrence.OccurrenceUnit", StringUtils.fromString(scheduledInstanceRecurrenceRequestRecurrence.getOccurrenceUnit()));
            }
        }
        if ((slotDateTimeRangeRequestFirstSlotStartTimeRange = describeScheduledInstanceAvailabilityRequest.getFirstSlotStartTimeRange()) != null) {
            if (slotDateTimeRangeRequestFirstSlotStartTimeRange.getEarliestTime() != null) {
                request.addParameter("FirstSlotStartTimeRange.EarliestTime", StringUtils.fromDate(slotDateTimeRangeRequestFirstSlotStartTimeRange.getEarliestTime()));
            }
            if (slotDateTimeRangeRequestFirstSlotStartTimeRange.getLatestTime() != null) {
                request.addParameter("FirstSlotStartTimeRange.LatestTime", StringUtils.fromDate(slotDateTimeRangeRequestFirstSlotStartTimeRange.getLatestTime()));
            }
        }
        if (describeScheduledInstanceAvailabilityRequest.getMinSlotDurationInHours() != null) {
            request.addParameter("MinSlotDurationInHours", StringUtils.fromInteger(describeScheduledInstanceAvailabilityRequest.getMinSlotDurationInHours()));
        }
        if (describeScheduledInstanceAvailabilityRequest.getMaxSlotDurationInHours() != null) {
            request.addParameter("MaxSlotDurationInHours", StringUtils.fromInteger(describeScheduledInstanceAvailabilityRequest.getMaxSlotDurationInHours()));
        }
        if (describeScheduledInstanceAvailabilityRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeScheduledInstanceAvailabilityRequest.getNextToken()));
        }
        if (describeScheduledInstanceAvailabilityRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeScheduledInstanceAvailabilityRequest.getMaxResults()));
        }
        List<Filter> filtersList = describeScheduledInstanceAvailabilityRequest.getFilters();
        int filtersListIndex = 1;
        for (Filter filtersListValue : filtersList) {
            Filter filterMember = filtersListValue;
            if (filterMember != null) {
                if (filterMember.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(filterMember.getName()));
                }
                List<String> valuesList = filterMember.getValues();
                int valuesListIndex = 1;
                for (String valuesListValue : valuesList) {
                    if (valuesListValue != null) {
                        request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                    }
                    ++valuesListIndex;
                }
            }
            ++filtersListIndex;
        }
        return request;
    }
}

