/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.buffered;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.buffered.AmazonSQSBufferedAsyncClient;
import com.amazonaws.services.sqs.buffered.QueueBufferCallback;
import com.amazonaws.services.sqs.buffered.QueueBufferConfig;
import com.amazonaws.services.sqs.buffered.QueueBufferFuture;
import com.amazonaws.services.sqs.buffered.ResultConverter;
import com.amazonaws.services.sqs.model.BatchResultErrorEntry;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchResult;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchResultEntry;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.DeleteMessageBatchResult;
import com.amazonaws.services.sqs.model.DeleteMessageBatchResultEntry;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.SendMessageBatchResult;
import com.amazonaws.services.sqs.model.SendMessageBatchResultEntry;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SendQueueBuffer {
    private static Log log = LogFactory.getLog(SendQueueBuffer.class);
    private final QueueBufferConfig config;
    private final String qUrl;
    private final AmazonSQS sqsClient;
    private final Executor executor;
    private final Object sendMessageLock = new Object();
    private final Object deleteMessageLock = new Object();
    private final Object changeMessageVisibilityLock = new Object();
    private final SendMessageBatchTask[] openSendMessageBatchTask = new SendMessageBatchTask[1];
    private final DeleteMessageBatchTask[] openDeleteMessageBatchTask = new DeleteMessageBatchTask[1];
    private final ChangeMessageVisibilityBatchTask[] openChangeMessageVisibilityBatchTask = new ChangeMessageVisibilityBatchTask[1];
    private final Semaphore inflightSendMessageBatches;
    private final Semaphore inflightDeleteMessageBatches;
    private final Semaphore inflightChangeMessageVisibilityBatches;

    SendQueueBuffer(AmazonSQS sqsClient, Executor executor, QueueBufferConfig paramConfig, String url) {
        this.sqsClient = sqsClient;
        this.executor = executor;
        this.config = paramConfig;
        this.qUrl = url;
        int maxBatch = this.config.getMaxInflightOutboundBatches();
        maxBatch = maxBatch > 0 ? maxBatch : 1;
        this.inflightSendMessageBatches = new Semaphore(maxBatch);
        this.inflightDeleteMessageBatches = new Semaphore(maxBatch);
        this.inflightChangeMessageVisibilityBatches = new Semaphore(maxBatch);
    }

    public QueueBufferConfig getConfig() {
        return this.config;
    }

    public QueueBufferFuture<SendMessageRequest, SendMessageResult> sendMessage(SendMessageRequest request, QueueBufferCallback<SendMessageRequest, SendMessageResult> callback) {
        QueueBufferFuture result = this.submitOutboundRequest(this.sendMessageLock, this.openSendMessageBatchTask, request, this.inflightSendMessageBatches, callback);
        return result;
    }

    public QueueBufferFuture<DeleteMessageRequest, Void> deleteMessage(DeleteMessageRequest request, QueueBufferCallback<DeleteMessageRequest, Void> callback) {
        return this.submitOutboundRequest(this.deleteMessageLock, this.openDeleteMessageBatchTask, request, this.inflightDeleteMessageBatches, callback);
    }

    public QueueBufferFuture<ChangeMessageVisibilityRequest, Void> changeMessageVisibility(ChangeMessageVisibilityRequest request, QueueBufferCallback<ChangeMessageVisibilityRequest, Void> callback) {
        return this.submitOutboundRequest(this.changeMessageVisibilityLock, this.openChangeMessageVisibilityBatchTask, request, this.inflightChangeMessageVisibilityBatches, callback);
    }

    private <R extends AmazonWebServiceRequest, Result> OutboundBatchTask<R, Result> newOutboundBatchTask(R request) {
        if (request instanceof SendMessageRequest) {
            return new SendMessageBatchTask();
        }
        if (request instanceof DeleteMessageRequest) {
            return new DeleteMessageBatchTask();
        }
        if (request instanceof ChangeMessageVisibilityRequest) {
            return new ChangeMessageVisibilityBatchTask();
        }
        throw new IllegalArgumentException("Unsupported request type " + request.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        try {
            Object object = this.sendMessageLock;
            synchronized (object) {
                this.inflightSendMessageBatches.acquire(this.config.getMaxInflightOutboundBatches());
                this.inflightSendMessageBatches.release(this.config.getMaxInflightOutboundBatches());
            }
            object = this.deleteMessageLock;
            synchronized (object) {
                this.inflightDeleteMessageBatches.acquire(this.config.getMaxInflightOutboundBatches());
                this.inflightDeleteMessageBatches.release(this.config.getMaxInflightOutboundBatches());
            }
            object = this.changeMessageVisibilityLock;
            synchronized (object) {
                this.inflightChangeMessageVisibilityBatches.acquire(this.config.getMaxInflightOutboundBatches());
                this.inflightChangeMessageVisibilityBatches.release(this.config.getMaxInflightOutboundBatches());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <OBT extends OutboundBatchTask<R, Result>, R extends AmazonWebServiceRequest, Result> QueueBufferFuture<R, Result> submitOutboundRequest(Object operationLock, OBT[] openOutboundBatchTask, R request, final Semaphore inflightOperationBatches, QueueBufferCallback<R, Result> callback) {
        QueueBufferFuture<R, Result> theFuture = null;
        try {
            Object object = operationLock;
            synchronized (object) {
                if (openOutboundBatchTask[0] == null || (theFuture = ((OutboundBatchTask)openOutboundBatchTask[0]).addRequest(request, callback)) == null) {
                    OutboundBatchTask<R, Result> obt = this.newOutboundBatchTask(request);
                    inflightOperationBatches.acquire();
                    openOutboundBatchTask[0] = obt;
                    ((OutboundBatchTask)openOutboundBatchTask[0]).setOnCompleted(new Listener<OutboundBatchTask<R, Result>>(){

                        @Override
                        public void invoke(OutboundBatchTask<R, Result> task) {
                            inflightOperationBatches.release();
                        }
                    });
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Queue " + this.qUrl + " created new batch for " + request.getClass().toString() + " " + inflightOperationBatches.availablePermits() + " free slots remain"));
                    }
                    theFuture = ((OutboundBatchTask)openOutboundBatchTask[0]).addRequest(request, callback);
                    this.executor.execute((Runnable)openOutboundBatchTask[0]);
                    if (null == theFuture) {
                        throw new AmazonClientException("Failed to schedule request " + request + " for execution");
                    }
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            AmazonClientException toThrow = new AmazonClientException("Interrupted while waiting for lock.");
            toThrow.initCause(e);
            throw toThrow;
        }
        return theFuture;
    }

    private class ChangeMessageVisibilityBatchTask
    extends OutboundBatchTask<ChangeMessageVisibilityRequest, Void> {
        private ChangeMessageVisibilityBatchTask() {
        }

        @Override
        protected void process(List<ChangeMessageVisibilityRequest> requests, List<QueueBufferFuture<ChangeMessageVisibilityRequest, Void>> futures) {
            int index;
            if (requests.isEmpty()) {
                return;
            }
            ChangeMessageVisibilityBatchRequest batchRequest = new ChangeMessageVisibilityBatchRequest().withQueueUrl(SendQueueBuffer.this.qUrl);
            ResultConverter.appendUserAgent(batchRequest, AmazonSQSBufferedAsyncClient.USER_AGENT);
            ArrayList<ChangeMessageVisibilityBatchRequestEntry> entries = new ArrayList<ChangeMessageVisibilityBatchRequestEntry>(requests.size());
            int n = requests.size();
            for (int i = 0; i < n; ++i) {
                entries.add(new ChangeMessageVisibilityBatchRequestEntry().withId(Integer.toString(i)).withReceiptHandle(requests.get(i).getReceiptHandle()).withVisibilityTimeout(requests.get(i).getVisibilityTimeout()));
            }
            batchRequest.setEntries(entries);
            ChangeMessageVisibilityBatchResult batchResult = SendQueueBuffer.this.sqsClient.changeMessageVisibilityBatch(batchRequest);
            for (ChangeMessageVisibilityBatchResultEntry entry : batchResult.getSuccessful()) {
                index = Integer.parseInt(entry.getId());
                futures.get(index).setSuccess(null);
            }
            for (BatchResultErrorEntry errorEntry : batchResult.getFailed()) {
                index = Integer.parseInt(errorEntry.getId());
                if (errorEntry.isSenderFault().booleanValue()) {
                    futures.get(index).setFailure(ResultConverter.convert(errorEntry));
                    continue;
                }
                try {
                    SendQueueBuffer.this.sqsClient.changeMessageVisibility(requests.get(index));
                    futures.get(index).setSuccess(null);
                }
                catch (AmazonClientException ace) {
                    futures.get(index).setFailure(ace);
                }
            }
        }
    }

    private class DeleteMessageBatchTask
    extends OutboundBatchTask<DeleteMessageRequest, Void> {
        private DeleteMessageBatchTask() {
        }

        @Override
        protected void process(List<DeleteMessageRequest> requests, List<QueueBufferFuture<DeleteMessageRequest, Void>> futures) {
            int index;
            if (requests.isEmpty()) {
                return;
            }
            DeleteMessageBatchRequest batchRequest = new DeleteMessageBatchRequest().withQueueUrl(SendQueueBuffer.this.qUrl);
            ResultConverter.appendUserAgent(batchRequest, AmazonSQSBufferedAsyncClient.USER_AGENT);
            ArrayList<DeleteMessageBatchRequestEntry> entries = new ArrayList<DeleteMessageBatchRequestEntry>(requests.size());
            int n = requests.size();
            for (int i = 0; i < n; ++i) {
                entries.add(new DeleteMessageBatchRequestEntry().withId(Integer.toString(i)).withReceiptHandle(requests.get(i).getReceiptHandle()));
            }
            batchRequest.setEntries(entries);
            DeleteMessageBatchResult batchResult = SendQueueBuffer.this.sqsClient.deleteMessageBatch(batchRequest);
            for (DeleteMessageBatchResultEntry entry : batchResult.getSuccessful()) {
                index = Integer.parseInt(entry.getId());
                futures.get(index).setSuccess(null);
            }
            for (BatchResultErrorEntry errorEntry : batchResult.getFailed()) {
                index = Integer.parseInt(errorEntry.getId());
                if (errorEntry.isSenderFault().booleanValue()) {
                    futures.get(index).setFailure(ResultConverter.convert(errorEntry));
                    continue;
                }
                try {
                    SendQueueBuffer.this.sqsClient.deleteMessage(requests.get(index));
                    futures.get(index).setSuccess(null);
                }
                catch (AmazonClientException ace) {
                    futures.get(index).setFailure(ace);
                }
            }
        }
    }

    private class SendMessageBatchTask
    extends OutboundBatchTask<SendMessageRequest, SendMessageResult> {
        int batchSizeBytes;

        private SendMessageBatchTask() {
            this.batchSizeBytes = 0;
        }

        @Override
        protected boolean isOkToAdd(SendMessageRequest request) {
            return this.requests.size() < SendQueueBuffer.this.config.getMaxBatchSize() && (long)(request.getMessageBody().getBytes().length + this.batchSizeBytes) < SendQueueBuffer.this.config.getMaxBatchSizeBytes();
        }

        @Override
        protected void onRequestAdded(SendMessageRequest request) {
            this.batchSizeBytes += request.getMessageBody().getBytes().length;
        }

        @Override
        protected boolean isFull() {
            return this.requests.size() >= SendQueueBuffer.this.config.getMaxBatchSize() || (long)this.batchSizeBytes >= SendQueueBuffer.this.config.getMaxBatchSizeBytes();
        }

        @Override
        protected void process(List<SendMessageRequest> requests, List<QueueBufferFuture<SendMessageRequest, SendMessageResult>> futures) {
            int index;
            if (requests.isEmpty()) {
                return;
            }
            SendMessageBatchRequest batchRequest = new SendMessageBatchRequest().withQueueUrl(SendQueueBuffer.this.qUrl);
            ResultConverter.appendUserAgent(batchRequest, AmazonSQSBufferedAsyncClient.USER_AGENT);
            ArrayList<SendMessageBatchRequestEntry> entries = new ArrayList<SendMessageBatchRequestEntry>(requests.size());
            int n = requests.size();
            for (int i = 0; i < n; ++i) {
                entries.add(new SendMessageBatchRequestEntry().withId(Integer.toString(i)).withMessageBody(requests.get(i).getMessageBody()).withDelaySeconds(requests.get(i).getDelaySeconds()).withMessageAttributes(requests.get(i).getMessageAttributes()));
            }
            batchRequest.setEntries(entries);
            SendMessageBatchResult batchResult = SendQueueBuffer.this.sqsClient.sendMessageBatch(batchRequest);
            for (SendMessageBatchResultEntry entry : batchResult.getSuccessful()) {
                index = Integer.parseInt(entry.getId());
                futures.get(index).setSuccess(ResultConverter.convert(entry));
            }
            for (BatchResultErrorEntry errorEntry : batchResult.getFailed()) {
                index = Integer.parseInt(errorEntry.getId());
                if (errorEntry.isSenderFault().booleanValue()) {
                    futures.get(index).setFailure(ResultConverter.convert(errorEntry));
                    continue;
                }
                try {
                    futures.get(index).setSuccess(SendQueueBuffer.this.sqsClient.sendMessage(requests.get(index)));
                }
                catch (AmazonClientException ace) {
                    futures.get(index).setFailure(ace);
                }
            }
        }
    }

    private abstract class OutboundBatchTask<R extends AmazonWebServiceRequest, Result>
    implements Runnable {
        protected final List<R> requests;
        protected final ArrayList<QueueBufferFuture<R, Result>> futures;
        private boolean closed;
        private volatile Listener<OutboundBatchTask<R, Result>> onCompleted;

        public OutboundBatchTask() {
            this.requests = new ArrayList<R>(SendQueueBuffer.this.config.getMaxBatchSize());
            this.futures = new ArrayList(SendQueueBuffer.this.config.getMaxBatchSize());
        }

        public void setOnCompleted(Listener<OutboundBatchTask<R, Result>> value) {
            this.onCompleted = value;
        }

        public synchronized QueueBufferFuture<R, Result> addRequest(R request, QueueBufferCallback<R, Result> callback) {
            if (this.closed) {
                return null;
            }
            QueueBufferFuture<R, Result> theFuture = this.addIfAllowed(request, callback);
            if (null == theFuture || this.isFull()) {
                this.closed = true;
                this.notify();
            }
            return theFuture;
        }

        private QueueBufferFuture<R, Result> addIfAllowed(R request, QueueBufferCallback<R, Result> callback) {
            if (this.isOkToAdd(request)) {
                this.requests.add(request);
                QueueBufferFuture<R, Result> theFuture = new QueueBufferFuture<R, Result>(callback);
                this.futures.add(theFuture);
                this.onRequestAdded(request);
                return theFuture;
            }
            return null;
        }

        protected boolean isOkToAdd(R request) {
            return this.requests.size() < SendQueueBuffer.this.config.getMaxBatchSize();
        }

        protected void onRequestAdded(R request) {
        }

        protected boolean isFull() {
            return this.requests.size() >= SendQueueBuffer.this.config.getMaxBatchSize();
        }

        protected abstract void process(List<R> var1, List<QueueBufferFuture<R, Result>> var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                ArrayList<QueueBufferFuture<R, Result>> futures;
                ArrayList<R> requests;
                long deadlineMs = TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS) + SendQueueBuffer.this.config.getMaxBatchOpenMs() + 1L;
                long t = TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
                OutboundBatchTask outboundBatchTask = this;
                synchronized (outboundBatchTask) {
                    while (!this.closed && t < deadlineMs) {
                        t = TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
                        long toWait = Math.max(1L, deadlineMs - t);
                        this.wait(toWait);
                    }
                    this.closed = true;
                    requests = new ArrayList<R>(this.requests);
                    futures = new ArrayList<QueueBufferFuture<R, Result>>(this.futures);
                }
                this.process(requests, futures);
            }
            catch (InterruptedException e) {
                this.failAll(e);
            }
            catch (AmazonClientException e) {
                this.failAll(e);
            }
            catch (RuntimeException e) {
                this.failAll(e);
                throw e;
            }
            catch (Error e) {
                this.failAll(new AmazonClientException("Error encountered", e));
                throw e;
            }
            finally {
                Listener<OutboundBatchTask<R, Result>> listener = this.onCompleted;
                if (listener != null) {
                    listener.invoke(this);
                }
            }
        }

        private void failAll(Exception e) {
            for (QueueBufferFuture<R, Result> f : this.futures) {
                f.setFailure(e);
            }
        }
    }

    private static interface Listener<T> {
        public void invoke(T var1);
    }
}

