/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.route53domains.model.ContactDetail;
import com.amazonaws.services.route53domains.model.ExtraParam;
import com.amazonaws.services.route53domains.model.transform.ExtraParamJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class ContactDetailJsonMarshaller {
    private static ContactDetailJsonMarshaller instance;

    public void marshall(ContactDetail contactDetail, JSONWriter jsonWriter) {
        if (contactDetail == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList extraParamsList;
            jsonWriter.object();
            if (contactDetail.getFirstName() != null) {
                jsonWriter.key("FirstName").value(contactDetail.getFirstName());
            }
            if (contactDetail.getLastName() != null) {
                jsonWriter.key("LastName").value(contactDetail.getLastName());
            }
            if (contactDetail.getContactType() != null) {
                jsonWriter.key("ContactType").value(contactDetail.getContactType());
            }
            if (contactDetail.getOrganizationName() != null) {
                jsonWriter.key("OrganizationName").value(contactDetail.getOrganizationName());
            }
            if (contactDetail.getAddressLine1() != null) {
                jsonWriter.key("AddressLine1").value(contactDetail.getAddressLine1());
            }
            if (contactDetail.getAddressLine2() != null) {
                jsonWriter.key("AddressLine2").value(contactDetail.getAddressLine2());
            }
            if (contactDetail.getCity() != null) {
                jsonWriter.key("City").value(contactDetail.getCity());
            }
            if (contactDetail.getState() != null) {
                jsonWriter.key("State").value(contactDetail.getState());
            }
            if (contactDetail.getCountryCode() != null) {
                jsonWriter.key("CountryCode").value(contactDetail.getCountryCode());
            }
            if (contactDetail.getZipCode() != null) {
                jsonWriter.key("ZipCode").value(contactDetail.getZipCode());
            }
            if (contactDetail.getPhoneNumber() != null) {
                jsonWriter.key("PhoneNumber").value(contactDetail.getPhoneNumber());
            }
            if (contactDetail.getEmail() != null) {
                jsonWriter.key("Email").value(contactDetail.getEmail());
            }
            if (contactDetail.getFax() != null) {
                jsonWriter.key("Fax").value(contactDetail.getFax());
            }
            if (!(extraParamsList = (SdkInternalList)contactDetail.getExtraParams()).isEmpty() || !extraParamsList.isAutoConstruct()) {
                jsonWriter.key("ExtraParams");
                jsonWriter.array();
                for (ExtraParam extraParamsListValue : extraParamsList) {
                    if (extraParamsListValue == null) continue;
                    ExtraParamJsonMarshaller.getInstance().marshall(extraParamsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ContactDetailJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ContactDetailJsonMarshaller();
        }
        return instance;
    }
}

