/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.iot.model.Action;
import com.amazonaws.services.iot.model.transform.DynamoDBActionJsonMarshaller;
import com.amazonaws.services.iot.model.transform.FirehoseActionJsonMarshaller;
import com.amazonaws.services.iot.model.transform.KinesisActionJsonMarshaller;
import com.amazonaws.services.iot.model.transform.LambdaActionJsonMarshaller;
import com.amazonaws.services.iot.model.transform.RepublishActionJsonMarshaller;
import com.amazonaws.services.iot.model.transform.S3ActionJsonMarshaller;
import com.amazonaws.services.iot.model.transform.SnsActionJsonMarshaller;
import com.amazonaws.services.iot.model.transform.SqsActionJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class ActionJsonMarshaller {
    private static ActionJsonMarshaller instance;

    public void marshall(Action action, JSONWriter jsonWriter) {
        if (action == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (action.getDynamoDB() != null) {
                jsonWriter.key("dynamoDB");
                DynamoDBActionJsonMarshaller.getInstance().marshall(action.getDynamoDB(), jsonWriter);
            }
            if (action.getLambda() != null) {
                jsonWriter.key("lambda");
                LambdaActionJsonMarshaller.getInstance().marshall(action.getLambda(), jsonWriter);
            }
            if (action.getSns() != null) {
                jsonWriter.key("sns");
                SnsActionJsonMarshaller.getInstance().marshall(action.getSns(), jsonWriter);
            }
            if (action.getSqs() != null) {
                jsonWriter.key("sqs");
                SqsActionJsonMarshaller.getInstance().marshall(action.getSqs(), jsonWriter);
            }
            if (action.getKinesis() != null) {
                jsonWriter.key("kinesis");
                KinesisActionJsonMarshaller.getInstance().marshall(action.getKinesis(), jsonWriter);
            }
            if (action.getRepublish() != null) {
                jsonWriter.key("republish");
                RepublishActionJsonMarshaller.getInstance().marshall(action.getRepublish(), jsonWriter);
            }
            if (action.getS3() != null) {
                jsonWriter.key("s3");
                S3ActionJsonMarshaller.getInstance().marshall(action.getS3(), jsonWriter);
            }
            if (action.getFirehose() != null) {
                jsonWriter.key("firehose");
                FirehoseActionJsonMarshaller.getInstance().marshall(action.getFirehose(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ActionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ActionJsonMarshaller();
        }
        return instance;
    }
}

