/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.inspector.model.LocalizeTextRequest;
import com.amazonaws.services.inspector.model.LocalizedText;
import com.amazonaws.services.inspector.model.transform.LocalizedTextJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

public class LocalizeTextRequestMarshaller
implements Marshaller<Request<LocalizeTextRequest>, LocalizeTextRequest> {
    @Override
    public Request<LocalizeTextRequest> marshall(LocalizeTextRequest localizeTextRequest) {
        if (localizeTextRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<LocalizeTextRequest> request = new DefaultRequest<LocalizeTextRequest>(localizeTextRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.LocalizeText");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            List<LocalizedText> localizedTextsList = localizeTextRequest.getLocalizedTexts();
            if (localizedTextsList != null) {
                jsonWriter.key("localizedTexts");
                jsonWriter.array();
                for (LocalizedText localizedTextsListValue : localizedTextsList) {
                    if (localizedTextsListValue == null) continue;
                    LocalizedTextJsonMarshaller.getInstance().marshall(localizedTextsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (localizeTextRequest.getLocale() != null) {
                jsonWriter.key("locale").value(localizeTextRequest.getLocale());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

