/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.Failure;
import com.amazonaws.services.ecs.model.Task;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeTasksResult
implements Serializable,
Cloneable {
    private SdkInternalList<Task> tasks;
    private SdkInternalList<Failure> failures;

    public List<Task> getTasks() {
        if (this.tasks == null) {
            this.tasks = new SdkInternalList();
        }
        return this.tasks;
    }

    public void setTasks(Collection<Task> tasks) {
        if (tasks == null) {
            this.tasks = null;
            return;
        }
        this.tasks = new SdkInternalList<Task>(tasks);
    }

    public DescribeTasksResult withTasks(Task ... tasks) {
        if (this.tasks == null) {
            this.setTasks(new SdkInternalList<Task>(tasks.length));
        }
        for (Task ele : tasks) {
            this.tasks.add(ele);
        }
        return this;
    }

    public DescribeTasksResult withTasks(Collection<Task> tasks) {
        this.setTasks(tasks);
        return this;
    }

    public List<Failure> getFailures() {
        if (this.failures == null) {
            this.failures = new SdkInternalList();
        }
        return this.failures;
    }

    public void setFailures(Collection<Failure> failures) {
        if (failures == null) {
            this.failures = null;
            return;
        }
        this.failures = new SdkInternalList<Failure>(failures);
    }

    public DescribeTasksResult withFailures(Failure ... failures) {
        if (this.failures == null) {
            this.setFailures(new SdkInternalList<Failure>(failures.length));
        }
        for (Failure ele : failures) {
            this.failures.add(ele);
        }
        return this;
    }

    public DescribeTasksResult withFailures(Collection<Failure> failures) {
        this.setFailures(failures);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTasks() != null) {
            sb.append("Tasks: " + this.getTasks() + ",");
        }
        if (this.getFailures() != null) {
            sb.append("Failures: " + this.getFailures());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTasksResult)) {
            return false;
        }
        DescribeTasksResult other = (DescribeTasksResult)obj;
        if (other.getTasks() == null ^ this.getTasks() == null) {
            return false;
        }
        if (other.getTasks() != null && !other.getTasks().equals(this.getTasks())) {
            return false;
        }
        if (other.getFailures() == null ^ this.getFailures() == null) {
            return false;
        }
        return other.getFailures() == null || other.getFailures().equals(this.getFailures());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTasks() == null ? 0 : this.getTasks().hashCode());
        hashCode = 31 * hashCode + (this.getFailures() == null ? 0 : this.getFailures().hashCode());
        return hashCode;
    }

    public DescribeTasksResult clone() {
        try {
            return (DescribeTasksResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

