/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ecr.model.BatchGetImageRequest;
import com.amazonaws.services.ecr.model.ImageIdentifier;
import com.amazonaws.services.ecr.model.transform.ImageIdentifierJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

public class BatchGetImageRequestMarshaller
implements Marshaller<Request<BatchGetImageRequest>, BatchGetImageRequest> {
    @Override
    public Request<BatchGetImageRequest> marshall(BatchGetImageRequest batchGetImageRequest) {
        if (batchGetImageRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<BatchGetImageRequest> request = new DefaultRequest<BatchGetImageRequest>(batchGetImageRequest, "AmazonECR");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerRegistry_V20150921.BatchGetImage");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<ImageIdentifier> imageIdsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (batchGetImageRequest.getRegistryId() != null) {
                jsonWriter.key("registryId").value(batchGetImageRequest.getRegistryId());
            }
            if (batchGetImageRequest.getRepositoryName() != null) {
                jsonWriter.key("repositoryName").value(batchGetImageRequest.getRepositoryName());
            }
            if ((imageIdsList = batchGetImageRequest.getImageIds()) != null) {
                jsonWriter.key("imageIds");
                jsonWriter.array();
                for (ImageIdentifier imageIdsListValue : imageIdsList) {
                    if (imageIdsListValue == null) continue;
                    ImageIdentifierJsonMarshaller.getInstance().marshall(imageIdsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

