/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeScheduledInstancesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.SlotStartTimeRangeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeScheduledInstancesRequestMarshaller
implements Marshaller<Request<DescribeScheduledInstancesRequest>, DescribeScheduledInstancesRequest> {
    @Override
    public Request<DescribeScheduledInstancesRequest> marshall(DescribeScheduledInstancesRequest describeScheduledInstancesRequest) {
        if (describeScheduledInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeScheduledInstancesRequest> request = new DefaultRequest<DescribeScheduledInstancesRequest>(describeScheduledInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeScheduledInstances");
        request.addParameter("Version", "2015-10-01");
        List<String> scheduledInstanceIdsList = describeScheduledInstancesRequest.getScheduledInstanceIds();
        int scheduledInstanceIdsListIndex = 1;
        for (String scheduledInstanceIdsListValue : scheduledInstanceIdsList) {
            if (scheduledInstanceIdsListValue != null) {
                request.addParameter("ScheduledInstanceId." + scheduledInstanceIdsListIndex, StringUtils.fromString(scheduledInstanceIdsListValue));
            }
            ++scheduledInstanceIdsListIndex;
        }
        SlotStartTimeRangeRequest slotStartTimeRangeRequestSlotStartTimeRange = describeScheduledInstancesRequest.getSlotStartTimeRange();
        if (slotStartTimeRangeRequestSlotStartTimeRange != null) {
            if (slotStartTimeRangeRequestSlotStartTimeRange.getEarliestTime() != null) {
                request.addParameter("SlotStartTimeRange.EarliestTime", StringUtils.fromDate(slotStartTimeRangeRequestSlotStartTimeRange.getEarliestTime()));
            }
            if (slotStartTimeRangeRequestSlotStartTimeRange.getLatestTime() != null) {
                request.addParameter("SlotStartTimeRange.LatestTime", StringUtils.fromDate(slotStartTimeRangeRequestSlotStartTimeRange.getLatestTime()));
            }
        }
        if (describeScheduledInstancesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeScheduledInstancesRequest.getNextToken()));
        }
        if (describeScheduledInstancesRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeScheduledInstancesRequest.getMaxResults()));
        }
        List<Filter> filtersList = describeScheduledInstancesRequest.getFilters();
        int filtersListIndex = 1;
        for (Filter filtersListValue : filtersList) {
            Filter filterMember = filtersListValue;
            if (filterMember != null) {
                if (filterMember.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(filterMember.getName()));
                }
                List<String> valuesList = filterMember.getValues();
                int valuesListIndex = 1;
                for (String valuesListValue : valuesList) {
                    if (valuesListValue != null) {
                        request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                    }
                    ++valuesListIndex;
                }
            }
            ++filtersListIndex;
        }
        return request;
    }
}

