/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.ScheduledInstanceRecurrenceRequest;
import com.amazonaws.services.ec2.model.SlotDateTimeRangeRequest;
import com.amazonaws.services.ec2.model.transform.DescribeScheduledInstanceAvailabilityRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeScheduledInstanceAvailabilityRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<DescribeScheduledInstanceAvailabilityRequest> {
    private ScheduledInstanceRecurrenceRequest recurrence;
    private SlotDateTimeRangeRequest firstSlotStartTimeRange;
    private Integer minSlotDurationInHours;
    private Integer maxSlotDurationInHours;
    private String nextToken;
    private Integer maxResults;
    private ListWithAutoConstructFlag<Filter> filters;

    public ScheduledInstanceRecurrenceRequest getRecurrence() {
        return this.recurrence;
    }

    public void setRecurrence(ScheduledInstanceRecurrenceRequest recurrence) {
        this.recurrence = recurrence;
    }

    public DescribeScheduledInstanceAvailabilityRequest withRecurrence(ScheduledInstanceRecurrenceRequest recurrence) {
        this.recurrence = recurrence;
        return this;
    }

    public SlotDateTimeRangeRequest getFirstSlotStartTimeRange() {
        return this.firstSlotStartTimeRange;
    }

    public void setFirstSlotStartTimeRange(SlotDateTimeRangeRequest firstSlotStartTimeRange) {
        this.firstSlotStartTimeRange = firstSlotStartTimeRange;
    }

    public DescribeScheduledInstanceAvailabilityRequest withFirstSlotStartTimeRange(SlotDateTimeRangeRequest firstSlotStartTimeRange) {
        this.firstSlotStartTimeRange = firstSlotStartTimeRange;
        return this;
    }

    public Integer getMinSlotDurationInHours() {
        return this.minSlotDurationInHours;
    }

    public void setMinSlotDurationInHours(Integer minSlotDurationInHours) {
        this.minSlotDurationInHours = minSlotDurationInHours;
    }

    public DescribeScheduledInstanceAvailabilityRequest withMinSlotDurationInHours(Integer minSlotDurationInHours) {
        this.minSlotDurationInHours = minSlotDurationInHours;
        return this;
    }

    public Integer getMaxSlotDurationInHours() {
        return this.maxSlotDurationInHours;
    }

    public void setMaxSlotDurationInHours(Integer maxSlotDurationInHours) {
        this.maxSlotDurationInHours = maxSlotDurationInHours;
    }

    public DescribeScheduledInstanceAvailabilityRequest withMaxSlotDurationInHours(Integer maxSlotDurationInHours) {
        this.maxSlotDurationInHours = maxSlotDurationInHours;
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public DescribeScheduledInstanceAvailabilityRequest withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public DescribeScheduledInstanceAvailabilityRequest withMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new ListWithAutoConstructFlag();
            this.filters.setAutoConstruct(true);
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
        filtersCopy.addAll(filters);
        this.filters = filtersCopy;
    }

    public DescribeScheduledInstanceAvailabilityRequest withFilters(Filter ... filters) {
        if (this.getFilters() == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter value : filters) {
            this.getFilters().add(value);
        }
        return this;
    }

    public DescribeScheduledInstanceAvailabilityRequest withFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
        } else {
            ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
            filtersCopy.addAll(filters);
            this.filters = filtersCopy;
        }
        return this;
    }

    @Override
    public Request<DescribeScheduledInstanceAvailabilityRequest> getDryRunRequest() {
        Request<DescribeScheduledInstanceAvailabilityRequest> request = new DescribeScheduledInstanceAvailabilityRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRecurrence() != null) {
            sb.append("Recurrence: " + this.getRecurrence() + ",");
        }
        if (this.getFirstSlotStartTimeRange() != null) {
            sb.append("FirstSlotStartTimeRange: " + this.getFirstSlotStartTimeRange() + ",");
        }
        if (this.getMinSlotDurationInHours() != null) {
            sb.append("MinSlotDurationInHours: " + this.getMinSlotDurationInHours() + ",");
        }
        if (this.getMaxSlotDurationInHours() != null) {
            sb.append("MaxSlotDurationInHours: " + this.getMaxSlotDurationInHours() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken() + ",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: " + this.getMaxResults() + ",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: " + this.getFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRecurrence() == null ? 0 : this.getRecurrence().hashCode());
        hashCode = 31 * hashCode + (this.getFirstSlotStartTimeRange() == null ? 0 : this.getFirstSlotStartTimeRange().hashCode());
        hashCode = 31 * hashCode + (this.getMinSlotDurationInHours() == null ? 0 : this.getMinSlotDurationInHours().hashCode());
        hashCode = 31 * hashCode + (this.getMaxSlotDurationInHours() == null ? 0 : this.getMaxSlotDurationInHours().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledInstanceAvailabilityRequest)) {
            return false;
        }
        DescribeScheduledInstanceAvailabilityRequest other = (DescribeScheduledInstanceAvailabilityRequest)obj;
        if (other.getRecurrence() == null ^ this.getRecurrence() == null) {
            return false;
        }
        if (other.getRecurrence() != null && !other.getRecurrence().equals(this.getRecurrence())) {
            return false;
        }
        if (other.getFirstSlotStartTimeRange() == null ^ this.getFirstSlotStartTimeRange() == null) {
            return false;
        }
        if (other.getFirstSlotStartTimeRange() != null && !other.getFirstSlotStartTimeRange().equals(this.getFirstSlotStartTimeRange())) {
            return false;
        }
        if (other.getMinSlotDurationInHours() == null ^ this.getMinSlotDurationInHours() == null) {
            return false;
        }
        if (other.getMinSlotDurationInHours() != null && !other.getMinSlotDurationInHours().equals(this.getMinSlotDurationInHours())) {
            return false;
        }
        if (other.getMaxSlotDurationInHours() == null ^ this.getMaxSlotDurationInHours() == null) {
            return false;
        }
        if (other.getMaxSlotDurationInHours() != null && !other.getMaxSlotDurationInHours().equals(this.getMaxSlotDurationInHours())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        return other.getFilters() == null || other.getFilters().equals(this.getFilters());
    }

    @Override
    public DescribeScheduledInstanceAvailabilityRequest clone() {
        return (DescribeScheduledInstanceAvailabilityRequest)super.clone();
    }
}

