/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.config.model.RecordingGroup;
import com.amazonaws.util.json.JSONWriter;

public class RecordingGroupJsonMarshaller {
    private static RecordingGroupJsonMarshaller instance;

    public void marshall(RecordingGroup recordingGroup, JSONWriter jsonWriter) {
        if (recordingGroup == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList resourceTypesList;
            jsonWriter.object();
            if (recordingGroup.getAllSupported() != null) {
                jsonWriter.key("allSupported").value(recordingGroup.getAllSupported());
            }
            if (recordingGroup.getIncludeGlobalResourceTypes() != null) {
                jsonWriter.key("includeGlobalResourceTypes").value(recordingGroup.getIncludeGlobalResourceTypes());
            }
            if (!(resourceTypesList = (SdkInternalList)recordingGroup.getResourceTypes()).isEmpty() || !resourceTypesList.isAutoConstruct()) {
                jsonWriter.key("resourceTypes");
                jsonWriter.array();
                for (String resourceTypesListValue : resourceTypesList) {
                    if (resourceTypesListValue == null) continue;
                    jsonWriter.value(resourceTypesListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RecordingGroupJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RecordingGroupJsonMarshaller();
        }
        return instance;
    }
}

