/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudhsm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudhsm.model.DescribeHsmRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DescribeHsmRequestMarshaller
implements Marshaller<Request<DescribeHsmRequest>, DescribeHsmRequest> {
    @Override
    public Request<DescribeHsmRequest> marshall(DescribeHsmRequest describeHsmRequest) {
        if (describeHsmRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeHsmRequest> request = new DefaultRequest<DescribeHsmRequest>(describeHsmRequest, "AWSCloudHSM");
        request.addHeader("X-Amz-Target", "CloudHsmFrontendService.DescribeHsm");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (describeHsmRequest.getHsmArn() != null) {
                jsonWriter.key("HsmArn").value(describeHsmRequest.getHsmArn());
            }
            if (describeHsmRequest.getHsmSerialNumber() != null) {
                jsonWriter.key("HsmSerialNumber").value(describeHsmRequest.getHsmSerialNumber());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

