/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.apigateway.model.MethodResponse;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class MethodResponseJsonMarshaller {
    private static MethodResponseJsonMarshaller instance;

    public void marshall(MethodResponse methodResponse, JSONWriter jsonWriter) {
        if (methodResponse == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, String> responseModelsMap;
            Map<String, Boolean> responseParametersMap;
            jsonWriter.object();
            if (methodResponse.getStatusCode() != null) {
                jsonWriter.key("statusCode").value(methodResponse.getStatusCode());
            }
            if ((responseParametersMap = methodResponse.getResponseParameters()) != null) {
                jsonWriter.key("responseParameters");
                jsonWriter.object();
                for (Map.Entry<String, Boolean> responseParametersMapValue : responseParametersMap.entrySet()) {
                    if (responseParametersMapValue.getValue() == null) continue;
                    jsonWriter.key(responseParametersMapValue.getKey());
                    jsonWriter.value(responseParametersMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if ((responseModelsMap = methodResponse.getResponseModels()) != null) {
                jsonWriter.key("responseModels");
                jsonWriter.object();
                for (Map.Entry<String, String> responseModelsMapValue : responseModelsMap.entrySet()) {
                    if (responseModelsMapValue.getValue() == null) continue;
                    jsonWriter.key(responseModelsMapValue.getKey());
                    jsonWriter.value(responseModelsMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static MethodResponseJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new MethodResponseJsonMarshaller();
        }
        return instance;
    }
}

