/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.Command;
import com.amazonaws.util.json.JSONWriter;

public class CommandJsonMarshaller {
    private static CommandJsonMarshaller instance;

    public void marshall(Command command, JSONWriter jsonWriter) {
        if (command == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList argsList;
            jsonWriter.object();
            if (command.getName() != null) {
                jsonWriter.key("Name").value(command.getName());
            }
            if (command.getScriptPath() != null) {
                jsonWriter.key("ScriptPath").value(command.getScriptPath());
            }
            if (!(argsList = (SdkInternalList)command.getArgs()).isEmpty() || !argsList.isAutoConstruct()) {
                jsonWriter.key("Args");
                jsonWriter.array();
                for (String argsListValue : argsList) {
                    if (argsListValue == null) continue;
                    jsonWriter.value(argsListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CommandJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CommandJsonMarshaller();
        }
        return instance;
    }
}

