/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.config.model.ListDiscoveredResourcesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class ListDiscoveredResourcesRequestMarshaller
implements Marshaller<Request<ListDiscoveredResourcesRequest>, ListDiscoveredResourcesRequest> {
    @Override
    public Request<ListDiscoveredResourcesRequest> marshall(ListDiscoveredResourcesRequest listDiscoveredResourcesRequest) {
        if (listDiscoveredResourcesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListDiscoveredResourcesRequest> request = new DefaultRequest<ListDiscoveredResourcesRequest>(listDiscoveredResourcesRequest, "AmazonConfig");
        request.addHeader("X-Amz-Target", "StarlingDoveService.ListDiscoveredResources");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList resourceIdsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (listDiscoveredResourcesRequest.getResourceType() != null) {
                jsonWriter.key("resourceType").value(listDiscoveredResourcesRequest.getResourceType());
            }
            if (!(resourceIdsList = (SdkInternalList)listDiscoveredResourcesRequest.getResourceIds()).isEmpty() || !resourceIdsList.isAutoConstruct()) {
                jsonWriter.key("resourceIds");
                jsonWriter.array();
                for (String resourceIdsListValue : resourceIdsList) {
                    if (resourceIdsListValue == null) continue;
                    jsonWriter.value(resourceIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (listDiscoveredResourcesRequest.getResourceName() != null) {
                jsonWriter.key("resourceName").value(listDiscoveredResourcesRequest.getResourceName());
            }
            if (listDiscoveredResourcesRequest.getLimit() != null) {
                jsonWriter.key("limit").value(listDiscoveredResourcesRequest.getLimit());
            }
            if (listDiscoveredResourcesRequest.getIncludeDeletedResources() != null) {
                jsonWriter.key("includeDeletedResources").value(listDiscoveredResourcesRequest.getIncludeDeletedResources());
            }
            if (listDiscoveredResourcesRequest.getNextToken() != null) {
                jsonWriter.key("nextToken").value(listDiscoveredResourcesRequest.getNextToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

