/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.waf.model.Predicate;
import com.amazonaws.services.waf.model.Rule;
import com.amazonaws.services.waf.model.transform.PredicateJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class RuleJsonMarshaller {
    private static RuleJsonMarshaller instance;

    public void marshall(Rule rule, JSONWriter jsonWriter) {
        if (rule == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Predicate> predicatesList;
            jsonWriter.object();
            if (rule.getRuleId() != null) {
                jsonWriter.key("RuleId").value(rule.getRuleId());
            }
            if (rule.getName() != null) {
                jsonWriter.key("Name").value(rule.getName());
            }
            if (rule.getMetricName() != null) {
                jsonWriter.key("MetricName").value(rule.getMetricName());
            }
            if ((predicatesList = rule.getPredicates()) != null) {
                jsonWriter.key("Predicates");
                jsonWriter.array();
                for (Predicate predicatesListValue : predicatesList) {
                    if (predicatesListValue == null) continue;
                    PredicateJsonMarshaller.getInstance().marshall(predicatesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RuleJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RuleJsonMarshaller();
        }
        return instance;
    }
}

