/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineRequest;
import com.amazonaws.services.elastictranscoder.model.transform.NotificationsJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.PipelineOutputConfigJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class UpdatePipelineRequestMarshaller
implements Marshaller<Request<UpdatePipelineRequest>, UpdatePipelineRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<UpdatePipelineRequest> marshall(UpdatePipelineRequest updatePipelineRequest) {
        if (updatePipelineRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdatePipelineRequest> request = new DefaultRequest<UpdatePipelineRequest>(updatePipelineRequest, "AmazonElasticTranscoder");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/2012-09-25/pipelines/{Id}";
        uriResourcePath = uriResourcePath.replace("{Id}", updatePipelineRequest.getId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(updatePipelineRequest.getId()));
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (updatePipelineRequest.getName() != null) {
                jsonWriter.key("Name").value(updatePipelineRequest.getName());
            }
            if (updatePipelineRequest.getInputBucket() != null) {
                jsonWriter.key("InputBucket").value(updatePipelineRequest.getInputBucket());
            }
            if (updatePipelineRequest.getRole() != null) {
                jsonWriter.key("Role").value(updatePipelineRequest.getRole());
            }
            if (updatePipelineRequest.getAwsKmsKeyArn() != null) {
                jsonWriter.key("AwsKmsKeyArn").value(updatePipelineRequest.getAwsKmsKeyArn());
            }
            if (updatePipelineRequest.getNotifications() != null) {
                jsonWriter.key("Notifications");
                NotificationsJsonMarshaller.getInstance().marshall(updatePipelineRequest.getNotifications(), jsonWriter);
            }
            if (updatePipelineRequest.getContentConfig() != null) {
                jsonWriter.key("ContentConfig");
                PipelineOutputConfigJsonMarshaller.getInstance().marshall(updatePipelineRequest.getContentConfig(), jsonWriter);
            }
            if (updatePipelineRequest.getThumbnailConfig() != null) {
                jsonWriter.key("ThumbnailConfig");
                PipelineOutputConfigJsonMarshaller.getInstance().marshall(updatePipelineRequest.getThumbnailConfig(), jsonWriter);
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

