/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elastictranscoder.model.Clip;
import com.amazonaws.services.elastictranscoder.model.JobOutput;
import com.amazonaws.services.elastictranscoder.model.JobWatermark;
import com.amazonaws.services.elastictranscoder.model.transform.CaptionsJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ClipJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.EncryptionJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.JobAlbumArtJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.JobWatermarkJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class JobOutputJsonMarshaller {
    private static JobOutputJsonMarshaller instance;

    public void marshall(JobOutput jobOutput, JSONWriter jsonWriter) {
        if (jobOutput == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList compositionList;
            SdkInternalList watermarksList;
            jsonWriter.object();
            if (jobOutput.getId() != null) {
                jsonWriter.key("Id").value(jobOutput.getId());
            }
            if (jobOutput.getKey() != null) {
                jsonWriter.key("Key").value(jobOutput.getKey());
            }
            if (jobOutput.getThumbnailPattern() != null) {
                jsonWriter.key("ThumbnailPattern").value(jobOutput.getThumbnailPattern());
            }
            if (jobOutput.getThumbnailEncryption() != null) {
                jsonWriter.key("ThumbnailEncryption");
                EncryptionJsonMarshaller.getInstance().marshall(jobOutput.getThumbnailEncryption(), jsonWriter);
            }
            if (jobOutput.getRotate() != null) {
                jsonWriter.key("Rotate").value(jobOutput.getRotate());
            }
            if (jobOutput.getPresetId() != null) {
                jsonWriter.key("PresetId").value(jobOutput.getPresetId());
            }
            if (jobOutput.getSegmentDuration() != null) {
                jsonWriter.key("SegmentDuration").value(jobOutput.getSegmentDuration());
            }
            if (jobOutput.getStatus() != null) {
                jsonWriter.key("Status").value(jobOutput.getStatus());
            }
            if (jobOutput.getStatusDetail() != null) {
                jsonWriter.key("StatusDetail").value(jobOutput.getStatusDetail());
            }
            if (jobOutput.getDuration() != null) {
                jsonWriter.key("Duration").value(jobOutput.getDuration());
            }
            if (jobOutput.getWidth() != null) {
                jsonWriter.key("Width").value(jobOutput.getWidth());
            }
            if (jobOutput.getHeight() != null) {
                jsonWriter.key("Height").value(jobOutput.getHeight());
            }
            if (jobOutput.getFrameRate() != null) {
                jsonWriter.key("FrameRate").value(jobOutput.getFrameRate());
            }
            if (jobOutput.getFileSize() != null) {
                jsonWriter.key("FileSize").value(jobOutput.getFileSize());
            }
            if (jobOutput.getDurationMillis() != null) {
                jsonWriter.key("DurationMillis").value(jobOutput.getDurationMillis());
            }
            if (!(watermarksList = (SdkInternalList)jobOutput.getWatermarks()).isEmpty() || !watermarksList.isAutoConstruct()) {
                jsonWriter.key("Watermarks");
                jsonWriter.array();
                for (JobWatermark watermarksListValue : watermarksList) {
                    if (watermarksListValue == null) continue;
                    JobWatermarkJsonMarshaller.getInstance().marshall(watermarksListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (jobOutput.getAlbumArt() != null) {
                jsonWriter.key("AlbumArt");
                JobAlbumArtJsonMarshaller.getInstance().marshall(jobOutput.getAlbumArt(), jsonWriter);
            }
            if (!(compositionList = (SdkInternalList)jobOutput.getComposition()).isEmpty() || !compositionList.isAutoConstruct()) {
                jsonWriter.key("Composition");
                jsonWriter.array();
                for (Clip compositionListValue : compositionList) {
                    if (compositionListValue == null) continue;
                    ClipJsonMarshaller.getInstance().marshall(compositionListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (jobOutput.getCaptions() != null) {
                jsonWriter.key("Captions");
                CaptionsJsonMarshaller.getInstance().marshall(jobOutput.getCaptions(), jsonWriter);
            }
            if (jobOutput.getEncryption() != null) {
                jsonWriter.key("Encryption");
                EncryptionJsonMarshaller.getInstance().marshall(jobOutput.getEncryption(), jsonWriter);
            }
            if (jobOutput.getAppliedColorSpaceConversion() != null) {
                jsonWriter.key("AppliedColorSpaceConversion").value(jobOutput.getAppliedColorSpaceConversion());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static JobOutputJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new JobOutputJsonMarshaller();
        }
        return instance;
    }
}

