/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticfilesystem.model.DeleteFileSystemRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DeleteFileSystemRequestMarshaller
implements Marshaller<Request<DeleteFileSystemRequest>, DeleteFileSystemRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<DeleteFileSystemRequest> marshall(DeleteFileSystemRequest deleteFileSystemRequest) {
        if (deleteFileSystemRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteFileSystemRequest> request = new DefaultRequest<DeleteFileSystemRequest>(deleteFileSystemRequest, "AmazonElasticFileSystem");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/2015-02-01/file-systems/{FileSystemId}";
        uriResourcePath = uriResourcePath.replace("{FileSystemId}", deleteFileSystemRequest.getFileSystemId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(deleteFileSystemRequest.getFileSystemId()));
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

