/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.GatewayType;
import com.amazonaws.services.ec2.model.transform.CreateCustomerGatewayRequestMarshaller;
import java.io.Serializable;

public class CreateCustomerGatewayRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreateCustomerGatewayRequest> {
    private String type;
    private String publicIp;
    private Integer bgpAsn;

    public CreateCustomerGatewayRequest() {
    }

    public CreateCustomerGatewayRequest(String type, String publicIp, Integer bgpAsn) {
        this.setType(type);
        this.setPublicIp(publicIp);
        this.setBgpAsn(bgpAsn);
    }

    public CreateCustomerGatewayRequest(GatewayType type, String publicIp, Integer bgpAsn) {
        this.type = type.toString();
        this.publicIp = publicIp;
        this.bgpAsn = bgpAsn;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public CreateCustomerGatewayRequest withType(String type) {
        this.type = type;
        return this;
    }

    public void setType(GatewayType type) {
        this.type = type.toString();
    }

    public CreateCustomerGatewayRequest withType(GatewayType type) {
        this.type = type.toString();
        return this;
    }

    public String getPublicIp() {
        return this.publicIp;
    }

    public void setPublicIp(String publicIp) {
        this.publicIp = publicIp;
    }

    public CreateCustomerGatewayRequest withPublicIp(String publicIp) {
        this.publicIp = publicIp;
        return this;
    }

    public Integer getBgpAsn() {
        return this.bgpAsn;
    }

    public void setBgpAsn(Integer bgpAsn) {
        this.bgpAsn = bgpAsn;
    }

    public CreateCustomerGatewayRequest withBgpAsn(Integer bgpAsn) {
        this.bgpAsn = bgpAsn;
        return this;
    }

    @Override
    public Request<CreateCustomerGatewayRequest> getDryRunRequest() {
        Request<CreateCustomerGatewayRequest> request = new CreateCustomerGatewayRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: " + this.getType() + ",");
        }
        if (this.getPublicIp() != null) {
            sb.append("PublicIp: " + this.getPublicIp() + ",");
        }
        if (this.getBgpAsn() != null) {
            sb.append("BgpAsn: " + this.getBgpAsn());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getPublicIp() == null ? 0 : this.getPublicIp().hashCode());
        hashCode = 31 * hashCode + (this.getBgpAsn() == null ? 0 : this.getBgpAsn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomerGatewayRequest)) {
            return false;
        }
        CreateCustomerGatewayRequest other = (CreateCustomerGatewayRequest)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getPublicIp() == null ^ this.getPublicIp() == null) {
            return false;
        }
        if (other.getPublicIp() != null && !other.getPublicIp().equals(this.getPublicIp())) {
            return false;
        }
        if (other.getBgpAsn() == null ^ this.getBgpAsn() == null) {
            return false;
        }
        return other.getBgpAsn() == null || other.getBgpAsn().equals(this.getBgpAsn());
    }

    @Override
    public CreateCustomerGatewayRequest clone() {
        return (CreateCustomerGatewayRequest)super.clone();
    }
}

