/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.TaskOverride;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class StartTaskRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cluster;
    private String taskDefinition;
    private TaskOverride overrides;
    private SdkInternalList<String> containerInstances;
    private String startedBy;

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getCluster() {
        return this.cluster;
    }

    public StartTaskRequest withCluster(String cluster) {
        this.setCluster(cluster);
        return this;
    }

    public void setTaskDefinition(String taskDefinition) {
        this.taskDefinition = taskDefinition;
    }

    public String getTaskDefinition() {
        return this.taskDefinition;
    }

    public StartTaskRequest withTaskDefinition(String taskDefinition) {
        this.setTaskDefinition(taskDefinition);
        return this;
    }

    public void setOverrides(TaskOverride overrides) {
        this.overrides = overrides;
    }

    public TaskOverride getOverrides() {
        return this.overrides;
    }

    public StartTaskRequest withOverrides(TaskOverride overrides) {
        this.setOverrides(overrides);
        return this;
    }

    public List<String> getContainerInstances() {
        if (this.containerInstances == null) {
            this.containerInstances = new SdkInternalList();
        }
        return this.containerInstances;
    }

    public void setContainerInstances(Collection<String> containerInstances) {
        if (containerInstances == null) {
            this.containerInstances = null;
            return;
        }
        this.containerInstances = new SdkInternalList<String>(containerInstances);
    }

    public StartTaskRequest withContainerInstances(String ... containerInstances) {
        if (this.containerInstances == null) {
            this.setContainerInstances(new SdkInternalList<String>(containerInstances.length));
        }
        for (String ele : containerInstances) {
            this.containerInstances.add(ele);
        }
        return this;
    }

    public StartTaskRequest withContainerInstances(Collection<String> containerInstances) {
        this.setContainerInstances(containerInstances);
        return this;
    }

    public void setStartedBy(String startedBy) {
        this.startedBy = startedBy;
    }

    public String getStartedBy() {
        return this.startedBy;
    }

    public StartTaskRequest withStartedBy(String startedBy) {
        this.setStartedBy(startedBy);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCluster() != null) {
            sb.append("Cluster: " + this.getCluster() + ",");
        }
        if (this.getTaskDefinition() != null) {
            sb.append("TaskDefinition: " + this.getTaskDefinition() + ",");
        }
        if (this.getOverrides() != null) {
            sb.append("Overrides: " + this.getOverrides() + ",");
        }
        if (this.getContainerInstances() != null) {
            sb.append("ContainerInstances: " + this.getContainerInstances() + ",");
        }
        if (this.getStartedBy() != null) {
            sb.append("StartedBy: " + this.getStartedBy());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTaskRequest)) {
            return false;
        }
        StartTaskRequest other = (StartTaskRequest)obj;
        if (other.getCluster() == null ^ this.getCluster() == null) {
            return false;
        }
        if (other.getCluster() != null && !other.getCluster().equals(this.getCluster())) {
            return false;
        }
        if (other.getTaskDefinition() == null ^ this.getTaskDefinition() == null) {
            return false;
        }
        if (other.getTaskDefinition() != null && !other.getTaskDefinition().equals(this.getTaskDefinition())) {
            return false;
        }
        if (other.getOverrides() == null ^ this.getOverrides() == null) {
            return false;
        }
        if (other.getOverrides() != null && !other.getOverrides().equals(this.getOverrides())) {
            return false;
        }
        if (other.getContainerInstances() == null ^ this.getContainerInstances() == null) {
            return false;
        }
        if (other.getContainerInstances() != null && !other.getContainerInstances().equals(this.getContainerInstances())) {
            return false;
        }
        if (other.getStartedBy() == null ^ this.getStartedBy() == null) {
            return false;
        }
        return other.getStartedBy() == null || other.getStartedBy().equals(this.getStartedBy());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCluster() == null ? 0 : this.getCluster().hashCode());
        hashCode = 31 * hashCode + (this.getTaskDefinition() == null ? 0 : this.getTaskDefinition().hashCode());
        hashCode = 31 * hashCode + (this.getOverrides() == null ? 0 : this.getOverrides().hashCode());
        hashCode = 31 * hashCode + (this.getContainerInstances() == null ? 0 : this.getContainerInstances().hashCode());
        hashCode = 31 * hashCode + (this.getStartedBy() == null ? 0 : this.getStartedBy().hashCode());
        return hashCode;
    }

    @Override
    public StartTaskRequest clone() {
        return (StartTaskRequest)super.clone();
    }
}

