/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.codedeploy.model.AutoScalingGroup;
import com.amazonaws.services.codedeploy.model.DeploymentGroupInfo;
import com.amazonaws.services.codedeploy.model.EC2TagFilter;
import com.amazonaws.services.codedeploy.model.TagFilter;
import com.amazonaws.services.codedeploy.model.transform.AutoScalingGroupJsonMarshaller;
import com.amazonaws.services.codedeploy.model.transform.EC2TagFilterJsonMarshaller;
import com.amazonaws.services.codedeploy.model.transform.RevisionLocationJsonMarshaller;
import com.amazonaws.services.codedeploy.model.transform.TagFilterJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class DeploymentGroupInfoJsonMarshaller {
    private static DeploymentGroupInfoJsonMarshaller instance;

    public void marshall(DeploymentGroupInfo deploymentGroupInfo, JSONWriter jsonWriter) {
        if (deploymentGroupInfo == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList autoScalingGroupsList;
            SdkInternalList onPremisesInstanceTagFiltersList;
            SdkInternalList ec2TagFiltersList;
            jsonWriter.object();
            if (deploymentGroupInfo.getApplicationName() != null) {
                jsonWriter.key("applicationName").value(deploymentGroupInfo.getApplicationName());
            }
            if (deploymentGroupInfo.getDeploymentGroupId() != null) {
                jsonWriter.key("deploymentGroupId").value(deploymentGroupInfo.getDeploymentGroupId());
            }
            if (deploymentGroupInfo.getDeploymentGroupName() != null) {
                jsonWriter.key("deploymentGroupName").value(deploymentGroupInfo.getDeploymentGroupName());
            }
            if (deploymentGroupInfo.getDeploymentConfigName() != null) {
                jsonWriter.key("deploymentConfigName").value(deploymentGroupInfo.getDeploymentConfigName());
            }
            if (!(ec2TagFiltersList = (SdkInternalList)deploymentGroupInfo.getEc2TagFilters()).isEmpty() || !ec2TagFiltersList.isAutoConstruct()) {
                jsonWriter.key("ec2TagFilters");
                jsonWriter.array();
                for (EC2TagFilter ec2TagFiltersListValue : ec2TagFiltersList) {
                    if (ec2TagFiltersListValue == null) continue;
                    EC2TagFilterJsonMarshaller.getInstance().marshall(ec2TagFiltersListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (!(onPremisesInstanceTagFiltersList = (SdkInternalList)deploymentGroupInfo.getOnPremisesInstanceTagFilters()).isEmpty() || !onPremisesInstanceTagFiltersList.isAutoConstruct()) {
                jsonWriter.key("onPremisesInstanceTagFilters");
                jsonWriter.array();
                for (TagFilter onPremisesInstanceTagFiltersListValue : onPremisesInstanceTagFiltersList) {
                    if (onPremisesInstanceTagFiltersListValue == null) continue;
                    TagFilterJsonMarshaller.getInstance().marshall(onPremisesInstanceTagFiltersListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (!(autoScalingGroupsList = (SdkInternalList)deploymentGroupInfo.getAutoScalingGroups()).isEmpty() || !autoScalingGroupsList.isAutoConstruct()) {
                jsonWriter.key("autoScalingGroups");
                jsonWriter.array();
                for (AutoScalingGroup autoScalingGroupsListValue : autoScalingGroupsList) {
                    if (autoScalingGroupsListValue == null) continue;
                    AutoScalingGroupJsonMarshaller.getInstance().marshall(autoScalingGroupsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (deploymentGroupInfo.getServiceRoleArn() != null) {
                jsonWriter.key("serviceRoleArn").value(deploymentGroupInfo.getServiceRoleArn());
            }
            if (deploymentGroupInfo.getTargetRevision() != null) {
                jsonWriter.key("targetRevision");
                RevisionLocationJsonMarshaller.getInstance().marshall(deploymentGroupInfo.getTargetRevision(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DeploymentGroupInfoJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DeploymentGroupInfoJsonMarshaller();
        }
        return instance;
    }
}

