/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.machinelearning.model.Prediction;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class PredictionJsonMarshaller {
    private static PredictionJsonMarshaller instance;

    public void marshall(Prediction prediction, JSONWriter jsonWriter) {
        if (prediction == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalMap detailsMap;
            SdkInternalMap predictedScoresMap;
            jsonWriter.object();
            if (prediction.getPredictedLabel() != null) {
                jsonWriter.key("predictedLabel").value(prediction.getPredictedLabel());
            }
            if (prediction.getPredictedValue() != null) {
                jsonWriter.key("predictedValue").value(prediction.getPredictedValue());
            }
            if (!(predictedScoresMap = (SdkInternalMap)prediction.getPredictedScores()).isEmpty() || !predictedScoresMap.isAutoConstruct()) {
                jsonWriter.key("predictedScores");
                jsonWriter.object();
                for (Map.Entry predictedScoresMapValue : predictedScoresMap.entrySet()) {
                    if (predictedScoresMapValue.getValue() == null) continue;
                    jsonWriter.key((String)predictedScoresMapValue.getKey());
                    jsonWriter.value(predictedScoresMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (!(detailsMap = (SdkInternalMap)prediction.getDetails()).isEmpty() || !detailsMap.isAutoConstruct()) {
                jsonWriter.key("details");
                jsonWriter.object();
                for (Map.Entry detailsMapValue : detailsMap.entrySet()) {
                    if (detailsMapValue.getValue() == null) continue;
                    jsonWriter.key((String)detailsMapValue.getKey());
                    jsonWriter.value(detailsMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PredictionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PredictionJsonMarshaller();
        }
        return instance;
    }
}

