/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.rds.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RestoreDBClusterFromSnapshotRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<String> availabilityZones;
    private String dBClusterIdentifier;
    private String snapshotIdentifier;
    private String engine;
    private String engineVersion;
    private Integer port;
    private String dBSubnetGroupName;
    private String databaseName;
    private String optionGroupName;
    private ListWithAutoConstructFlag<String> vpcSecurityGroupIds;
    private ListWithAutoConstructFlag<Tag> tags;
    private String kmsKeyId;

    public List<String> getAvailabilityZones() {
        if (this.availabilityZones == null) {
            this.availabilityZones = new ListWithAutoConstructFlag();
            this.availabilityZones.setAutoConstruct(true);
        }
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Collection<String> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
            return;
        }
        ListWithAutoConstructFlag availabilityZonesCopy = new ListWithAutoConstructFlag(availabilityZones.size());
        availabilityZonesCopy.addAll(availabilityZones);
        this.availabilityZones = availabilityZonesCopy;
    }

    public RestoreDBClusterFromSnapshotRequest withAvailabilityZones(String ... availabilityZones) {
        if (this.getAvailabilityZones() == null) {
            this.setAvailabilityZones(new ArrayList<String>(availabilityZones.length));
        }
        for (String value : availabilityZones) {
            this.getAvailabilityZones().add(value);
        }
        return this;
    }

    public RestoreDBClusterFromSnapshotRequest withAvailabilityZones(Collection<String> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
        } else {
            ListWithAutoConstructFlag availabilityZonesCopy = new ListWithAutoConstructFlag(availabilityZones.size());
            availabilityZonesCopy.addAll(availabilityZones);
            this.availabilityZones = availabilityZonesCopy;
        }
        return this;
    }

    public String getDBClusterIdentifier() {
        return this.dBClusterIdentifier;
    }

    public void setDBClusterIdentifier(String dBClusterIdentifier) {
        this.dBClusterIdentifier = dBClusterIdentifier;
    }

    public RestoreDBClusterFromSnapshotRequest withDBClusterIdentifier(String dBClusterIdentifier) {
        this.dBClusterIdentifier = dBClusterIdentifier;
        return this;
    }

    public String getSnapshotIdentifier() {
        return this.snapshotIdentifier;
    }

    public void setSnapshotIdentifier(String snapshotIdentifier) {
        this.snapshotIdentifier = snapshotIdentifier;
    }

    public RestoreDBClusterFromSnapshotRequest withSnapshotIdentifier(String snapshotIdentifier) {
        this.snapshotIdentifier = snapshotIdentifier;
        return this;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public RestoreDBClusterFromSnapshotRequest withEngine(String engine) {
        this.engine = engine;
        return this;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public RestoreDBClusterFromSnapshotRequest withEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public RestoreDBClusterFromSnapshotRequest withPort(Integer port) {
        this.port = port;
        return this;
    }

    public String getDBSubnetGroupName() {
        return this.dBSubnetGroupName;
    }

    public void setDBSubnetGroupName(String dBSubnetGroupName) {
        this.dBSubnetGroupName = dBSubnetGroupName;
    }

    public RestoreDBClusterFromSnapshotRequest withDBSubnetGroupName(String dBSubnetGroupName) {
        this.dBSubnetGroupName = dBSubnetGroupName;
        return this;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public RestoreDBClusterFromSnapshotRequest withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public String getOptionGroupName() {
        return this.optionGroupName;
    }

    public void setOptionGroupName(String optionGroupName) {
        this.optionGroupName = optionGroupName;
    }

    public RestoreDBClusterFromSnapshotRequest withOptionGroupName(String optionGroupName) {
        this.optionGroupName = optionGroupName;
        return this;
    }

    public List<String> getVpcSecurityGroupIds() {
        if (this.vpcSecurityGroupIds == null) {
            this.vpcSecurityGroupIds = new ListWithAutoConstructFlag();
            this.vpcSecurityGroupIds.setAutoConstruct(true);
        }
        return this.vpcSecurityGroupIds;
    }

    public void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
        if (vpcSecurityGroupIds == null) {
            this.vpcSecurityGroupIds = null;
            return;
        }
        ListWithAutoConstructFlag vpcSecurityGroupIdsCopy = new ListWithAutoConstructFlag(vpcSecurityGroupIds.size());
        vpcSecurityGroupIdsCopy.addAll(vpcSecurityGroupIds);
        this.vpcSecurityGroupIds = vpcSecurityGroupIdsCopy;
    }

    public RestoreDBClusterFromSnapshotRequest withVpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
        if (this.getVpcSecurityGroupIds() == null) {
            this.setVpcSecurityGroupIds(new ArrayList<String>(vpcSecurityGroupIds.length));
        }
        for (String value : vpcSecurityGroupIds) {
            this.getVpcSecurityGroupIds().add(value);
        }
        return this;
    }

    public RestoreDBClusterFromSnapshotRequest withVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
        if (vpcSecurityGroupIds == null) {
            this.vpcSecurityGroupIds = null;
        } else {
            ListWithAutoConstructFlag vpcSecurityGroupIdsCopy = new ListWithAutoConstructFlag(vpcSecurityGroupIds.size());
            vpcSecurityGroupIdsCopy.addAll(vpcSecurityGroupIds);
            this.vpcSecurityGroupIds = vpcSecurityGroupIdsCopy;
        }
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public RestoreDBClusterFromSnapshotRequest withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public RestoreDBClusterFromSnapshotRequest withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public RestoreDBClusterFromSnapshotRequest withKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAvailabilityZones() != null) {
            sb.append("AvailabilityZones: " + this.getAvailabilityZones() + ",");
        }
        if (this.getDBClusterIdentifier() != null) {
            sb.append("DBClusterIdentifier: " + this.getDBClusterIdentifier() + ",");
        }
        if (this.getSnapshotIdentifier() != null) {
            sb.append("SnapshotIdentifier: " + this.getSnapshotIdentifier() + ",");
        }
        if (this.getEngine() != null) {
            sb.append("Engine: " + this.getEngine() + ",");
        }
        if (this.getEngineVersion() != null) {
            sb.append("EngineVersion: " + this.getEngineVersion() + ",");
        }
        if (this.getPort() != null) {
            sb.append("Port: " + this.getPort() + ",");
        }
        if (this.getDBSubnetGroupName() != null) {
            sb.append("DBSubnetGroupName: " + this.getDBSubnetGroupName() + ",");
        }
        if (this.getDatabaseName() != null) {
            sb.append("DatabaseName: " + this.getDatabaseName() + ",");
        }
        if (this.getOptionGroupName() != null) {
            sb.append("OptionGroupName: " + this.getOptionGroupName() + ",");
        }
        if (this.getVpcSecurityGroupIds() != null) {
            sb.append("VpcSecurityGroupIds: " + this.getVpcSecurityGroupIds() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags() + ",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: " + this.getKmsKeyId());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAvailabilityZones() == null ? 0 : this.getAvailabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.getDBClusterIdentifier() == null ? 0 : this.getDBClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotIdentifier() == null ? 0 : this.getSnapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getEngine() == null ? 0 : this.getEngine().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getPort() == null ? 0 : this.getPort().hashCode());
        hashCode = 31 * hashCode + (this.getDBSubnetGroupName() == null ? 0 : this.getDBSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getDatabaseName() == null ? 0 : this.getDatabaseName().hashCode());
        hashCode = 31 * hashCode + (this.getOptionGroupName() == null ? 0 : this.getOptionGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getVpcSecurityGroupIds() == null ? 0 : this.getVpcSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreDBClusterFromSnapshotRequest)) {
            return false;
        }
        RestoreDBClusterFromSnapshotRequest other = (RestoreDBClusterFromSnapshotRequest)obj;
        if (other.getAvailabilityZones() == null ^ this.getAvailabilityZones() == null) {
            return false;
        }
        if (other.getAvailabilityZones() != null && !other.getAvailabilityZones().equals(this.getAvailabilityZones())) {
            return false;
        }
        if (other.getDBClusterIdentifier() == null ^ this.getDBClusterIdentifier() == null) {
            return false;
        }
        if (other.getDBClusterIdentifier() != null && !other.getDBClusterIdentifier().equals(this.getDBClusterIdentifier())) {
            return false;
        }
        if (other.getSnapshotIdentifier() == null ^ this.getSnapshotIdentifier() == null) {
            return false;
        }
        if (other.getSnapshotIdentifier() != null && !other.getSnapshotIdentifier().equals(this.getSnapshotIdentifier())) {
            return false;
        }
        if (other.getEngine() == null ^ this.getEngine() == null) {
            return false;
        }
        if (other.getEngine() != null && !other.getEngine().equals(this.getEngine())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.getPort() == null ^ this.getPort() == null) {
            return false;
        }
        if (other.getPort() != null && !other.getPort().equals(this.getPort())) {
            return false;
        }
        if (other.getDBSubnetGroupName() == null ^ this.getDBSubnetGroupName() == null) {
            return false;
        }
        if (other.getDBSubnetGroupName() != null && !other.getDBSubnetGroupName().equals(this.getDBSubnetGroupName())) {
            return false;
        }
        if (other.getDatabaseName() == null ^ this.getDatabaseName() == null) {
            return false;
        }
        if (other.getDatabaseName() != null && !other.getDatabaseName().equals(this.getDatabaseName())) {
            return false;
        }
        if (other.getOptionGroupName() == null ^ this.getOptionGroupName() == null) {
            return false;
        }
        if (other.getOptionGroupName() != null && !other.getOptionGroupName().equals(this.getOptionGroupName())) {
            return false;
        }
        if (other.getVpcSecurityGroupIds() == null ^ this.getVpcSecurityGroupIds() == null) {
            return false;
        }
        if (other.getVpcSecurityGroupIds() != null && !other.getVpcSecurityGroupIds().equals(this.getVpcSecurityGroupIds())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        return other.getKmsKeyId() == null || other.getKmsKeyId().equals(this.getKmsKeyId());
    }

    @Override
    public RestoreDBClusterFromSnapshotRequest clone() {
        return (RestoreDBClusterFromSnapshotRequest)super.clone();
    }
}

