/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.TransferCertificateRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class TransferCertificateRequestMarshaller
implements Marshaller<Request<TransferCertificateRequest>, TransferCertificateRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<TransferCertificateRequest> marshall(TransferCertificateRequest transferCertificateRequest) {
        String targetAwsAccount;
        if (transferCertificateRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<TransferCertificateRequest> request = new DefaultRequest<TransferCertificateRequest>(transferCertificateRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.PATCH);
        String uriResourcePath = "/transfer-certificate/{certificateId}";
        uriResourcePath = uriResourcePath.replace("{certificateId}", transferCertificateRequest.getCertificateId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(transferCertificateRequest.getCertificateId()));
        request.setResourcePath(uriResourcePath);
        String string = targetAwsAccount = transferCertificateRequest.getTargetAwsAccount() == null ? null : StringUtils.fromString(transferCertificateRequest.getTargetAwsAccount());
        if (targetAwsAccount != null) {
            request.addParameter("targetAwsAccount", targetAwsAccount);
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

