/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.ListTopicRulesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class ListTopicRulesRequestMarshaller
implements Marshaller<Request<ListTopicRulesRequest>, ListTopicRulesRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<ListTopicRulesRequest> marshall(ListTopicRulesRequest listTopicRulesRequest) {
        String ruleDisabled;
        String nextToken;
        String maxResults;
        String topic;
        if (listTopicRulesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListTopicRulesRequest> request = new DefaultRequest<ListTopicRulesRequest>(listTopicRulesRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/rules";
        request.setResourcePath(uriResourcePath);
        String string = topic = listTopicRulesRequest.getTopic() == null ? null : StringUtils.fromString(listTopicRulesRequest.getTopic());
        if (topic != null) {
            request.addParameter("topic", topic);
        }
        String string2 = maxResults = listTopicRulesRequest.getMaxResults() == null ? null : StringUtils.fromInteger(listTopicRulesRequest.getMaxResults());
        if (maxResults != null) {
            request.addParameter("maxResults", maxResults);
        }
        String string3 = nextToken = listTopicRulesRequest.getNextToken() == null ? null : StringUtils.fromString(listTopicRulesRequest.getNextToken());
        if (nextToken != null) {
            request.addParameter("nextToken", nextToken);
        }
        String string4 = ruleDisabled = listTopicRulesRequest.getRuleDisabled() == null ? null : StringUtils.fromBoolean(listTopicRulesRequest.getRuleDisabled());
        if (ruleDisabled != null) {
            request.addParameter("ruleDisabled", ruleDisabled);
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

