/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.ListPrincipalPoliciesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class ListPrincipalPoliciesRequestMarshaller
implements Marshaller<Request<ListPrincipalPoliciesRequest>, ListPrincipalPoliciesRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<ListPrincipalPoliciesRequest> marshall(ListPrincipalPoliciesRequest listPrincipalPoliciesRequest) {
        String ascendingOrder;
        String pageSize;
        String marker;
        if (listPrincipalPoliciesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListPrincipalPoliciesRequest> request = new DefaultRequest<ListPrincipalPoliciesRequest>(listPrincipalPoliciesRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        if (listPrincipalPoliciesRequest.getPrincipal() != null) {
            request.addHeader("x-amzn-iot-principal", StringUtils.fromString(listPrincipalPoliciesRequest.getPrincipal()));
        }
        String uriResourcePath = "/principal-policies";
        request.setResourcePath(uriResourcePath);
        String string = marker = listPrincipalPoliciesRequest.getMarker() == null ? null : StringUtils.fromString(listPrincipalPoliciesRequest.getMarker());
        if (marker != null) {
            request.addParameter("marker", marker);
        }
        String string2 = pageSize = listPrincipalPoliciesRequest.getPageSize() == null ? null : StringUtils.fromInteger(listPrincipalPoliciesRequest.getPageSize());
        if (pageSize != null) {
            request.addParameter("pageSize", pageSize);
        }
        String string3 = ascendingOrder = listPrincipalPoliciesRequest.getAscendingOrder() == null ? null : StringUtils.fromBoolean(listPrincipalPoliciesRequest.getAscendingOrder());
        if (ascendingOrder != null) {
            request.addParameter("isAscendingOrder", ascendingOrder);
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

