/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.importexport.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.importexport.model.Artifact;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class UpdateJobResult
implements Serializable,
Cloneable {
    private Boolean success;
    private String warningMessage;
    private SdkInternalList<Artifact> artifactList;

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public UpdateJobResult withSuccess(Boolean success) {
        this.setSuccess(success);
        return this;
    }

    public Boolean isSuccess() {
        return this.success;
    }

    public void setWarningMessage(String warningMessage) {
        this.warningMessage = warningMessage;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public UpdateJobResult withWarningMessage(String warningMessage) {
        this.setWarningMessage(warningMessage);
        return this;
    }

    public List<Artifact> getArtifactList() {
        if (this.artifactList == null) {
            this.artifactList = new SdkInternalList();
        }
        return this.artifactList;
    }

    public void setArtifactList(Collection<Artifact> artifactList) {
        if (artifactList == null) {
            this.artifactList = null;
            return;
        }
        this.artifactList = new SdkInternalList<Artifact>(artifactList);
    }

    public UpdateJobResult withArtifactList(Artifact ... artifactList) {
        if (this.artifactList == null) {
            this.setArtifactList(new SdkInternalList<Artifact>(artifactList.length));
        }
        for (Artifact ele : artifactList) {
            this.artifactList.add(ele);
        }
        return this;
    }

    public UpdateJobResult withArtifactList(Collection<Artifact> artifactList) {
        this.setArtifactList(artifactList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSuccess() != null) {
            sb.append("Success: " + this.getSuccess() + ",");
        }
        if (this.getWarningMessage() != null) {
            sb.append("WarningMessage: " + this.getWarningMessage() + ",");
        }
        if (this.getArtifactList() != null) {
            sb.append("ArtifactList: " + this.getArtifactList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJobResult)) {
            return false;
        }
        UpdateJobResult other = (UpdateJobResult)obj;
        if (other.getSuccess() == null ^ this.getSuccess() == null) {
            return false;
        }
        if (other.getSuccess() != null && !other.getSuccess().equals(this.getSuccess())) {
            return false;
        }
        if (other.getWarningMessage() == null ^ this.getWarningMessage() == null) {
            return false;
        }
        if (other.getWarningMessage() != null && !other.getWarningMessage().equals(this.getWarningMessage())) {
            return false;
        }
        if (other.getArtifactList() == null ^ this.getArtifactList() == null) {
            return false;
        }
        return other.getArtifactList() == null || other.getArtifactList().equals(this.getArtifactList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSuccess() == null ? 0 : this.getSuccess().hashCode());
        hashCode = 31 * hashCode + (this.getWarningMessage() == null ? 0 : this.getWarningMessage().hashCode());
        hashCode = 31 * hashCode + (this.getArtifactList() == null ? 0 : this.getArtifactList().hashCode());
        return hashCode;
    }

    public UpdateJobResult clone() {
        try {
            return (UpdateJobResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

