/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.cloudtrail.model.PublicKey;
import com.amazonaws.util.json.JSONWriter;

public class PublicKeyJsonMarshaller {
    private static PublicKeyJsonMarshaller instance;

    public void marshall(PublicKey publicKey, JSONWriter jsonWriter) {
        if (publicKey == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (publicKey.getValue() != null) {
                jsonWriter.key("Value").value(publicKey.getValue());
            }
            if (publicKey.getValidityStartTime() != null) {
                jsonWriter.key("ValidityStartTime").value(publicKey.getValidityStartTime());
            }
            if (publicKey.getValidityEndTime() != null) {
                jsonWriter.key("ValidityEndTime").value(publicKey.getValidityEndTime());
            }
            if (publicKey.getFingerprint() != null) {
                jsonWriter.key("Fingerprint").value(publicKey.getFingerprint());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PublicKeyJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PublicKeyJsonMarshaller();
        }
        return instance;
    }
}

