/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.ListDistributionsByWebACLIdRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ListDistributionsByWebACLIdRequestMarshaller
implements Marshaller<Request<ListDistributionsByWebACLIdRequest>, ListDistributionsByWebACLIdRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    @Override
    public Request<ListDistributionsByWebACLIdRequest> marshall(ListDistributionsByWebACLIdRequest listDistributionsByWebACLIdRequest) {
        String value;
        String name;
        if (listDistributionsByWebACLIdRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListDistributionsByWebACLIdRequest> request = new DefaultRequest<ListDistributionsByWebACLIdRequest>(listDistributionsByWebACLIdRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        if (DYNAMIC_QUERY_PARAMS.containsKey("Marker")) {
            name = DYNAMIC_QUERY_PARAMS.get("Marker");
            String string = value = listDistributionsByWebACLIdRequest.getMarker() == null ? null : StringUtils.fromString(listDistributionsByWebACLIdRequest.getMarker());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Marker}", listDistributionsByWebACLIdRequest.getMarker() == null ? "" : StringUtils.fromString(listDistributionsByWebACLIdRequest.getMarker()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("MaxItems")) {
            name = DYNAMIC_QUERY_PARAMS.get("MaxItems");
            String string = value = listDistributionsByWebACLIdRequest.getMaxItems() == null ? null : StringUtils.fromString(listDistributionsByWebACLIdRequest.getMaxItems());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{MaxItems}", listDistributionsByWebACLIdRequest.getMaxItems() == null ? "" : StringUtils.fromString(listDistributionsByWebACLIdRequest.getMaxItems()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("WebACLId")) {
            name = DYNAMIC_QUERY_PARAMS.get("WebACLId");
            String string = value = listDistributionsByWebACLIdRequest.getWebACLId() == null ? null : StringUtils.fromString(listDistributionsByWebACLIdRequest.getWebACLId());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{WebACLId}", listDistributionsByWebACLIdRequest.getWebACLId() == null ? "" : StringUtils.fromString(listDistributionsByWebACLIdRequest.getWebACLId()));
        }
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        return request;
    }

    static {
        String path = "2015-07-27/distributionsByWebACLId/{WebACLId}?Marker={Marker}&MaxItems={MaxItems}";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

