/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AssignInstanceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String instanceId;
    private ListWithAutoConstructFlag<String> layerIds;

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public AssignInstanceRequest withInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public List<String> getLayerIds() {
        if (this.layerIds == null) {
            this.layerIds = new ListWithAutoConstructFlag();
            this.layerIds.setAutoConstruct(true);
        }
        return this.layerIds;
    }

    public void setLayerIds(Collection<String> layerIds) {
        if (layerIds == null) {
            this.layerIds = null;
            return;
        }
        ListWithAutoConstructFlag layerIdsCopy = new ListWithAutoConstructFlag(layerIds.size());
        layerIdsCopy.addAll(layerIds);
        this.layerIds = layerIdsCopy;
    }

    public AssignInstanceRequest withLayerIds(String ... layerIds) {
        if (this.getLayerIds() == null) {
            this.setLayerIds(new ArrayList<String>(layerIds.length));
        }
        for (String value : layerIds) {
            this.getLayerIds().add(value);
        }
        return this;
    }

    public AssignInstanceRequest withLayerIds(Collection<String> layerIds) {
        if (layerIds == null) {
            this.layerIds = null;
        } else {
            ListWithAutoConstructFlag layerIdsCopy = new ListWithAutoConstructFlag(layerIds.size());
            layerIdsCopy.addAll(layerIds);
            this.layerIds = layerIdsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: " + this.getInstanceId() + ",");
        }
        if (this.getLayerIds() != null) {
            sb.append("LayerIds: " + this.getLayerIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getLayerIds() == null ? 0 : this.getLayerIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignInstanceRequest)) {
            return false;
        }
        AssignInstanceRequest other = (AssignInstanceRequest)obj;
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getLayerIds() == null ^ this.getLayerIds() == null) {
            return false;
        }
        return other.getLayerIds() == null || other.getLayerIds().equals(this.getLayerIds());
    }

    @Override
    public AssignInstanceRequest clone() {
        return (AssignInstanceRequest)super.clone();
    }
}

