/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.services.elasticloadbalancing.model.ConnectionDraining;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class ConnectionDrainingStaxUnmarshaller
implements Unmarshaller<ConnectionDraining, StaxUnmarshallerContext> {
    private static ConnectionDrainingStaxUnmarshaller instance;

    @Override
    public ConnectionDraining unmarshall(StaxUnmarshallerContext context) throws Exception {
        ConnectionDraining connectionDraining = new ConnectionDraining();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return connectionDraining;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Enabled", targetDepth)) {
                    connectionDraining.setEnabled(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Timeout", targetDepth)) continue;
                connectionDraining.setTimeout(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return connectionDraining;
    }

    public static ConnectionDrainingStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ConnectionDrainingStaxUnmarshaller();
        }
        return instance;
    }
}

