/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DetachInstancesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<String> instanceIds;
    private String autoScalingGroupName;
    private Boolean shouldDecrementDesiredCapacity;

    public List<String> getInstanceIds() {
        if (this.instanceIds == null) {
            this.instanceIds = new ListWithAutoConstructFlag();
            this.instanceIds.setAutoConstruct(true);
        }
        return this.instanceIds;
    }

    public void setInstanceIds(Collection<String> instanceIds) {
        if (instanceIds == null) {
            this.instanceIds = null;
            return;
        }
        ListWithAutoConstructFlag instanceIdsCopy = new ListWithAutoConstructFlag(instanceIds.size());
        instanceIdsCopy.addAll(instanceIds);
        this.instanceIds = instanceIdsCopy;
    }

    public DetachInstancesRequest withInstanceIds(String ... instanceIds) {
        if (this.getInstanceIds() == null) {
            this.setInstanceIds(new ArrayList<String>(instanceIds.length));
        }
        for (String value : instanceIds) {
            this.getInstanceIds().add(value);
        }
        return this;
    }

    public DetachInstancesRequest withInstanceIds(Collection<String> instanceIds) {
        if (instanceIds == null) {
            this.instanceIds = null;
        } else {
            ListWithAutoConstructFlag instanceIdsCopy = new ListWithAutoConstructFlag(instanceIds.size());
            instanceIdsCopy.addAll(instanceIds);
            this.instanceIds = instanceIdsCopy;
        }
        return this;
    }

    public String getAutoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public void setAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
    }

    public DetachInstancesRequest withAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
        return this;
    }

    public Boolean isShouldDecrementDesiredCapacity() {
        return this.shouldDecrementDesiredCapacity;
    }

    public void setShouldDecrementDesiredCapacity(Boolean shouldDecrementDesiredCapacity) {
        this.shouldDecrementDesiredCapacity = shouldDecrementDesiredCapacity;
    }

    public DetachInstancesRequest withShouldDecrementDesiredCapacity(Boolean shouldDecrementDesiredCapacity) {
        this.shouldDecrementDesiredCapacity = shouldDecrementDesiredCapacity;
        return this;
    }

    public Boolean getShouldDecrementDesiredCapacity() {
        return this.shouldDecrementDesiredCapacity;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceIds() != null) {
            sb.append("InstanceIds: " + this.getInstanceIds() + ",");
        }
        if (this.getAutoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: " + this.getAutoScalingGroupName() + ",");
        }
        if (this.isShouldDecrementDesiredCapacity() != null) {
            sb.append("ShouldDecrementDesiredCapacity: " + this.isShouldDecrementDesiredCapacity());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceIds() == null ? 0 : this.getInstanceIds().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingGroupName() == null ? 0 : this.getAutoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.isShouldDecrementDesiredCapacity() == null ? 0 : this.isShouldDecrementDesiredCapacity().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachInstancesRequest)) {
            return false;
        }
        DetachInstancesRequest other = (DetachInstancesRequest)obj;
        if (other.getInstanceIds() == null ^ this.getInstanceIds() == null) {
            return false;
        }
        if (other.getInstanceIds() != null && !other.getInstanceIds().equals(this.getInstanceIds())) {
            return false;
        }
        if (other.getAutoScalingGroupName() == null ^ this.getAutoScalingGroupName() == null) {
            return false;
        }
        if (other.getAutoScalingGroupName() != null && !other.getAutoScalingGroupName().equals(this.getAutoScalingGroupName())) {
            return false;
        }
        if (other.isShouldDecrementDesiredCapacity() == null ^ this.isShouldDecrementDesiredCapacity() == null) {
            return false;
        }
        return other.isShouldDecrementDesiredCapacity() == null || other.isShouldDecrementDesiredCapacity().equals(this.isShouldDecrementDesiredCapacity());
    }

    @Override
    public DetachInstancesRequest clone() {
        return (DetachInstancesRequest)super.clone();
    }
}

