/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.service.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.service.codepipeline.model.ActionDeclaration;
import com.amazonaws.service.codepipeline.model.BlockerDeclaration;
import com.amazonaws.service.codepipeline.model.StageDeclaration;
import com.amazonaws.service.codepipeline.model.transform.ActionDeclarationJsonMarshaller;
import com.amazonaws.service.codepipeline.model.transform.BlockerDeclarationJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class StageDeclarationJsonMarshaller {
    private static StageDeclarationJsonMarshaller instance;

    public void marshall(StageDeclaration stageDeclaration, JSONWriter jsonWriter) {
        if (stageDeclaration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<ActionDeclaration> actionsList;
            List<BlockerDeclaration> blockersList;
            jsonWriter.object();
            if (stageDeclaration.getName() != null) {
                jsonWriter.key("name").value(stageDeclaration.getName());
            }
            if ((blockersList = stageDeclaration.getBlockers()) != null) {
                jsonWriter.key("blockers");
                jsonWriter.array();
                for (BlockerDeclaration blockersListValue : blockersList) {
                    if (blockersListValue == null) continue;
                    BlockerDeclarationJsonMarshaller.getInstance().marshall(blockersListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if ((actionsList = stageDeclaration.getActions()) != null) {
                jsonWriter.key("actions");
                jsonWriter.array();
                for (ActionDeclaration actionsListValue : actionsList) {
                    if (actionsListValue == null) continue;
                    ActionDeclarationJsonMarshaller.getInstance().marshall(actionsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StageDeclarationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StageDeclarationJsonMarshaller();
        }
        return instance;
    }
}

