/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.service.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.service.codepipeline.model.Job;
import com.amazonaws.service.codepipeline.model.transform.JobDataJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class JobJsonMarshaller {
    private static JobJsonMarshaller instance;

    public void marshall(Job job, JSONWriter jsonWriter) {
        if (job == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (job.getId() != null) {
                jsonWriter.key("id").value(job.getId());
            }
            if (job.getData() != null) {
                jsonWriter.key("data");
                JobDataJsonMarshaller.getInstance().marshall(job.getData(), jsonWriter);
            }
            if (job.getNonce() != null) {
                jsonWriter.key("nonce").value(job.getNonce());
            }
            if (job.getAccountId() != null) {
                jsonWriter.key("accountId").value(job.getAccountId());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static JobJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new JobJsonMarshaller();
        }
        return instance;
    }
}

