/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.service.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.service.codepipeline.model.ActionState;
import com.amazonaws.service.codepipeline.model.transform.ActionExecutionJsonMarshaller;
import com.amazonaws.service.codepipeline.model.transform.ActionRevisionJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class ActionStateJsonMarshaller {
    private static ActionStateJsonMarshaller instance;

    public void marshall(ActionState actionState, JSONWriter jsonWriter) {
        if (actionState == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (actionState.getActionName() != null) {
                jsonWriter.key("actionName").value(actionState.getActionName());
            }
            if (actionState.getCurrentRevision() != null) {
                jsonWriter.key("currentRevision");
                ActionRevisionJsonMarshaller.getInstance().marshall(actionState.getCurrentRevision(), jsonWriter);
            }
            if (actionState.getLatestExecution() != null) {
                jsonWriter.key("latestExecution");
                ActionExecutionJsonMarshaller.getInstance().marshall(actionState.getLatestExecution(), jsonWriter);
            }
            if (actionState.getEntityUrl() != null) {
                jsonWriter.key("entityUrl").value(actionState.getEntityUrl());
            }
            if (actionState.getRevisionUrl() != null) {
                jsonWriter.key("revisionUrl").value(actionState.getRevisionUrl());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ActionStateJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ActionStateJsonMarshaller();
        }
        return instance;
    }
}

