/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.kinesisfirehose.model.S3DestinationUpdate;
import com.amazonaws.services.kinesisfirehose.model.transform.BufferingHintsJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.EncryptionConfigurationJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class S3DestinationUpdateJsonMarshaller {
    private static S3DestinationUpdateJsonMarshaller instance;

    public void marshall(S3DestinationUpdate s3DestinationUpdate, JSONWriter jsonWriter) {
        if (s3DestinationUpdate == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (s3DestinationUpdate.getRoleARN() != null) {
                jsonWriter.key("RoleARN").value(s3DestinationUpdate.getRoleARN());
            }
            if (s3DestinationUpdate.getBucketARN() != null) {
                jsonWriter.key("BucketARN").value(s3DestinationUpdate.getBucketARN());
            }
            if (s3DestinationUpdate.getPrefix() != null) {
                jsonWriter.key("Prefix").value(s3DestinationUpdate.getPrefix());
            }
            if (s3DestinationUpdate.getBufferingHints() != null) {
                jsonWriter.key("BufferingHints");
                BufferingHintsJsonMarshaller.getInstance().marshall(s3DestinationUpdate.getBufferingHints(), jsonWriter);
            }
            if (s3DestinationUpdate.getCompressionFormat() != null) {
                jsonWriter.key("CompressionFormat").value(s3DestinationUpdate.getCompressionFormat());
            }
            if (s3DestinationUpdate.getEncryptionConfiguration() != null) {
                jsonWriter.key("EncryptionConfiguration");
                EncryptionConfigurationJsonMarshaller.getInstance().marshall(s3DestinationUpdate.getEncryptionConfiguration(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static S3DestinationUpdateJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new S3DestinationUpdateJsonMarshaller();
        }
        return instance;
    }
}

