/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.devicefarm.model.ScheduleRunRequest;
import com.amazonaws.services.devicefarm.model.transform.ScheduleRunConfigurationJsonMarshaller;
import com.amazonaws.services.devicefarm.model.transform.ScheduleRunTestJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class ScheduleRunRequestMarshaller
implements Marshaller<Request<ScheduleRunRequest>, ScheduleRunRequest> {
    @Override
    public Request<ScheduleRunRequest> marshall(ScheduleRunRequest scheduleRunRequest) {
        if (scheduleRunRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ScheduleRunRequest> request = new DefaultRequest<ScheduleRunRequest>(scheduleRunRequest, "AWSDeviceFarm");
        request.addHeader("X-Amz-Target", "DeviceFarm_20150623.ScheduleRun");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (scheduleRunRequest.getProjectArn() != null) {
                jsonWriter.key("projectArn").value(scheduleRunRequest.getProjectArn());
            }
            if (scheduleRunRequest.getAppArn() != null) {
                jsonWriter.key("appArn").value(scheduleRunRequest.getAppArn());
            }
            if (scheduleRunRequest.getDevicePoolArn() != null) {
                jsonWriter.key("devicePoolArn").value(scheduleRunRequest.getDevicePoolArn());
            }
            if (scheduleRunRequest.getName() != null) {
                jsonWriter.key("name").value(scheduleRunRequest.getName());
            }
            if (scheduleRunRequest.getTest() != null) {
                jsonWriter.key("test");
                ScheduleRunTestJsonMarshaller.getInstance().marshall(scheduleRunRequest.getTest(), jsonWriter);
            }
            if (scheduleRunRequest.getConfiguration() != null) {
                jsonWriter.key("configuration");
                ScheduleRunConfigurationJsonMarshaller.getInstance().marshall(scheduleRunRequest.getConfiguration(), jsonWriter);
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

