/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.simpleemail.model.ReceiptAction;
import com.amazonaws.services.simpleemail.model.TlsPolicy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ReceiptRule
implements Serializable,
Cloneable {
    private String name;
    private Boolean enabled;
    private String tlsPolicy;
    private ListWithAutoConstructFlag<String> recipients;
    private ListWithAutoConstructFlag<ReceiptAction> actions;
    private Boolean scanEnabled;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ReceiptRule withName(String name) {
        this.name = name;
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public ReceiptRule withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public String getTlsPolicy() {
        return this.tlsPolicy;
    }

    public void setTlsPolicy(String tlsPolicy) {
        this.tlsPolicy = tlsPolicy;
    }

    public ReceiptRule withTlsPolicy(String tlsPolicy) {
        this.tlsPolicy = tlsPolicy;
        return this;
    }

    public void setTlsPolicy(TlsPolicy tlsPolicy) {
        this.tlsPolicy = tlsPolicy.toString();
    }

    public ReceiptRule withTlsPolicy(TlsPolicy tlsPolicy) {
        this.tlsPolicy = tlsPolicy.toString();
        return this;
    }

    public List<String> getRecipients() {
        if (this.recipients == null) {
            this.recipients = new ListWithAutoConstructFlag();
            this.recipients.setAutoConstruct(true);
        }
        return this.recipients;
    }

    public void setRecipients(Collection<String> recipients) {
        if (recipients == null) {
            this.recipients = null;
            return;
        }
        ListWithAutoConstructFlag recipientsCopy = new ListWithAutoConstructFlag(recipients.size());
        recipientsCopy.addAll(recipients);
        this.recipients = recipientsCopy;
    }

    public ReceiptRule withRecipients(String ... recipients) {
        if (this.getRecipients() == null) {
            this.setRecipients(new ArrayList<String>(recipients.length));
        }
        for (String value : recipients) {
            this.getRecipients().add(value);
        }
        return this;
    }

    public ReceiptRule withRecipients(Collection<String> recipients) {
        if (recipients == null) {
            this.recipients = null;
        } else {
            ListWithAutoConstructFlag recipientsCopy = new ListWithAutoConstructFlag(recipients.size());
            recipientsCopy.addAll(recipients);
            this.recipients = recipientsCopy;
        }
        return this;
    }

    public List<ReceiptAction> getActions() {
        if (this.actions == null) {
            this.actions = new ListWithAutoConstructFlag();
            this.actions.setAutoConstruct(true);
        }
        return this.actions;
    }

    public void setActions(Collection<ReceiptAction> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        ListWithAutoConstructFlag actionsCopy = new ListWithAutoConstructFlag(actions.size());
        actionsCopy.addAll(actions);
        this.actions = actionsCopy;
    }

    public ReceiptRule withActions(ReceiptAction ... actions) {
        if (this.getActions() == null) {
            this.setActions(new ArrayList<ReceiptAction>(actions.length));
        }
        for (ReceiptAction value : actions) {
            this.getActions().add(value);
        }
        return this;
    }

    public ReceiptRule withActions(Collection<ReceiptAction> actions) {
        if (actions == null) {
            this.actions = null;
        } else {
            ListWithAutoConstructFlag actionsCopy = new ListWithAutoConstructFlag(actions.size());
            actionsCopy.addAll(actions);
            this.actions = actionsCopy;
        }
        return this;
    }

    public Boolean isScanEnabled() {
        return this.scanEnabled;
    }

    public void setScanEnabled(Boolean scanEnabled) {
        this.scanEnabled = scanEnabled;
    }

    public ReceiptRule withScanEnabled(Boolean scanEnabled) {
        this.scanEnabled = scanEnabled;
        return this;
    }

    public Boolean getScanEnabled() {
        return this.scanEnabled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.isEnabled() != null) {
            sb.append("Enabled: " + this.isEnabled() + ",");
        }
        if (this.getTlsPolicy() != null) {
            sb.append("TlsPolicy: " + this.getTlsPolicy() + ",");
        }
        if (this.getRecipients() != null) {
            sb.append("Recipients: " + this.getRecipients() + ",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: " + this.getActions() + ",");
        }
        if (this.isScanEnabled() != null) {
            sb.append("ScanEnabled: " + this.isScanEnabled());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.isEnabled() == null ? 0 : this.isEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getTlsPolicy() == null ? 0 : this.getTlsPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getRecipients() == null ? 0 : this.getRecipients().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        hashCode = 31 * hashCode + (this.isScanEnabled() == null ? 0 : this.isScanEnabled().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiptRule)) {
            return false;
        }
        ReceiptRule other = (ReceiptRule)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.isEnabled() == null ^ this.isEnabled() == null) {
            return false;
        }
        if (other.isEnabled() != null && !other.isEnabled().equals(this.isEnabled())) {
            return false;
        }
        if (other.getTlsPolicy() == null ^ this.getTlsPolicy() == null) {
            return false;
        }
        if (other.getTlsPolicy() != null && !other.getTlsPolicy().equals(this.getTlsPolicy())) {
            return false;
        }
        if (other.getRecipients() == null ^ this.getRecipients() == null) {
            return false;
        }
        if (other.getRecipients() != null && !other.getRecipients().equals(this.getRecipients())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        if (other.getActions() != null && !other.getActions().equals(this.getActions())) {
            return false;
        }
        if (other.isScanEnabled() == null ^ this.isScanEnabled() == null) {
            return false;
        }
        return other.isScanEnabled() == null || other.isScanEnabled().equals(this.isScanEnabled());
    }

    public ReceiptRule clone() {
        try {
            return (ReceiptRule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

