/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.rds.model.DBClusterMember;
import com.amazonaws.services.rds.model.DBClusterOptionGroupStatus;
import com.amazonaws.services.rds.model.VpcSecurityGroupMembership;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DBCluster
implements Serializable,
Cloneable {
    private Integer allocatedStorage;
    private ListWithAutoConstructFlag<String> availabilityZones;
    private Integer backupRetentionPeriod;
    private String characterSetName;
    private String databaseName;
    private String dBClusterIdentifier;
    private String dBClusterParameterGroup;
    private String dBSubnetGroup;
    private String status;
    private String percentProgress;
    private Date earliestRestorableTime;
    private String endpoint;
    private String engine;
    private String engineVersion;
    private Date latestRestorableTime;
    private Integer port;
    private String masterUsername;
    private ListWithAutoConstructFlag<DBClusterOptionGroupStatus> dBClusterOptionGroupMemberships;
    private String preferredBackupWindow;
    private String preferredMaintenanceWindow;
    private ListWithAutoConstructFlag<DBClusterMember> dBClusterMembers;
    private ListWithAutoConstructFlag<VpcSecurityGroupMembership> vpcSecurityGroups;
    private String hostedZoneId;

    public Integer getAllocatedStorage() {
        return this.allocatedStorage;
    }

    public void setAllocatedStorage(Integer allocatedStorage) {
        this.allocatedStorage = allocatedStorage;
    }

    public DBCluster withAllocatedStorage(Integer allocatedStorage) {
        this.allocatedStorage = allocatedStorage;
        return this;
    }

    public List<String> getAvailabilityZones() {
        if (this.availabilityZones == null) {
            this.availabilityZones = new ListWithAutoConstructFlag();
            this.availabilityZones.setAutoConstruct(true);
        }
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Collection<String> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
            return;
        }
        ListWithAutoConstructFlag availabilityZonesCopy = new ListWithAutoConstructFlag(availabilityZones.size());
        availabilityZonesCopy.addAll(availabilityZones);
        this.availabilityZones = availabilityZonesCopy;
    }

    public DBCluster withAvailabilityZones(String ... availabilityZones) {
        if (this.getAvailabilityZones() == null) {
            this.setAvailabilityZones(new ArrayList<String>(availabilityZones.length));
        }
        for (String value : availabilityZones) {
            this.getAvailabilityZones().add(value);
        }
        return this;
    }

    public DBCluster withAvailabilityZones(Collection<String> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
        } else {
            ListWithAutoConstructFlag availabilityZonesCopy = new ListWithAutoConstructFlag(availabilityZones.size());
            availabilityZonesCopy.addAll(availabilityZones);
            this.availabilityZones = availabilityZonesCopy;
        }
        return this;
    }

    public Integer getBackupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
        this.backupRetentionPeriod = backupRetentionPeriod;
    }

    public DBCluster withBackupRetentionPeriod(Integer backupRetentionPeriod) {
        this.backupRetentionPeriod = backupRetentionPeriod;
        return this;
    }

    public String getCharacterSetName() {
        return this.characterSetName;
    }

    public void setCharacterSetName(String characterSetName) {
        this.characterSetName = characterSetName;
    }

    public DBCluster withCharacterSetName(String characterSetName) {
        this.characterSetName = characterSetName;
        return this;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public DBCluster withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public String getDBClusterIdentifier() {
        return this.dBClusterIdentifier;
    }

    public void setDBClusterIdentifier(String dBClusterIdentifier) {
        this.dBClusterIdentifier = dBClusterIdentifier;
    }

    public DBCluster withDBClusterIdentifier(String dBClusterIdentifier) {
        this.dBClusterIdentifier = dBClusterIdentifier;
        return this;
    }

    public String getDBClusterParameterGroup() {
        return this.dBClusterParameterGroup;
    }

    public void setDBClusterParameterGroup(String dBClusterParameterGroup) {
        this.dBClusterParameterGroup = dBClusterParameterGroup;
    }

    public DBCluster withDBClusterParameterGroup(String dBClusterParameterGroup) {
        this.dBClusterParameterGroup = dBClusterParameterGroup;
        return this;
    }

    public String getDBSubnetGroup() {
        return this.dBSubnetGroup;
    }

    public void setDBSubnetGroup(String dBSubnetGroup) {
        this.dBSubnetGroup = dBSubnetGroup;
    }

    public DBCluster withDBSubnetGroup(String dBSubnetGroup) {
        this.dBSubnetGroup = dBSubnetGroup;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public DBCluster withStatus(String status) {
        this.status = status;
        return this;
    }

    public String getPercentProgress() {
        return this.percentProgress;
    }

    public void setPercentProgress(String percentProgress) {
        this.percentProgress = percentProgress;
    }

    public DBCluster withPercentProgress(String percentProgress) {
        this.percentProgress = percentProgress;
        return this;
    }

    public Date getEarliestRestorableTime() {
        return this.earliestRestorableTime;
    }

    public void setEarliestRestorableTime(Date earliestRestorableTime) {
        this.earliestRestorableTime = earliestRestorableTime;
    }

    public DBCluster withEarliestRestorableTime(Date earliestRestorableTime) {
        this.earliestRestorableTime = earliestRestorableTime;
        return this;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public DBCluster withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public DBCluster withEngine(String engine) {
        this.engine = engine;
        return this;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public DBCluster withEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
        return this;
    }

    public Date getLatestRestorableTime() {
        return this.latestRestorableTime;
    }

    public void setLatestRestorableTime(Date latestRestorableTime) {
        this.latestRestorableTime = latestRestorableTime;
    }

    public DBCluster withLatestRestorableTime(Date latestRestorableTime) {
        this.latestRestorableTime = latestRestorableTime;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public DBCluster withPort(Integer port) {
        this.port = port;
        return this;
    }

    public String getMasterUsername() {
        return this.masterUsername;
    }

    public void setMasterUsername(String masterUsername) {
        this.masterUsername = masterUsername;
    }

    public DBCluster withMasterUsername(String masterUsername) {
        this.masterUsername = masterUsername;
        return this;
    }

    public List<DBClusterOptionGroupStatus> getDBClusterOptionGroupMemberships() {
        if (this.dBClusterOptionGroupMemberships == null) {
            this.dBClusterOptionGroupMemberships = new ListWithAutoConstructFlag();
            this.dBClusterOptionGroupMemberships.setAutoConstruct(true);
        }
        return this.dBClusterOptionGroupMemberships;
    }

    public void setDBClusterOptionGroupMemberships(Collection<DBClusterOptionGroupStatus> dBClusterOptionGroupMemberships) {
        if (dBClusterOptionGroupMemberships == null) {
            this.dBClusterOptionGroupMemberships = null;
            return;
        }
        ListWithAutoConstructFlag dBClusterOptionGroupMembershipsCopy = new ListWithAutoConstructFlag(dBClusterOptionGroupMemberships.size());
        dBClusterOptionGroupMembershipsCopy.addAll(dBClusterOptionGroupMemberships);
        this.dBClusterOptionGroupMemberships = dBClusterOptionGroupMembershipsCopy;
    }

    public DBCluster withDBClusterOptionGroupMemberships(DBClusterOptionGroupStatus ... dBClusterOptionGroupMemberships) {
        if (this.getDBClusterOptionGroupMemberships() == null) {
            this.setDBClusterOptionGroupMemberships(new ArrayList<DBClusterOptionGroupStatus>(dBClusterOptionGroupMemberships.length));
        }
        for (DBClusterOptionGroupStatus value : dBClusterOptionGroupMemberships) {
            this.getDBClusterOptionGroupMemberships().add(value);
        }
        return this;
    }

    public DBCluster withDBClusterOptionGroupMemberships(Collection<DBClusterOptionGroupStatus> dBClusterOptionGroupMemberships) {
        if (dBClusterOptionGroupMemberships == null) {
            this.dBClusterOptionGroupMemberships = null;
        } else {
            ListWithAutoConstructFlag dBClusterOptionGroupMembershipsCopy = new ListWithAutoConstructFlag(dBClusterOptionGroupMemberships.size());
            dBClusterOptionGroupMembershipsCopy.addAll(dBClusterOptionGroupMemberships);
            this.dBClusterOptionGroupMemberships = dBClusterOptionGroupMembershipsCopy;
        }
        return this;
    }

    public String getPreferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public void setPreferredBackupWindow(String preferredBackupWindow) {
        this.preferredBackupWindow = preferredBackupWindow;
    }

    public DBCluster withPreferredBackupWindow(String preferredBackupWindow) {
        this.preferredBackupWindow = preferredBackupWindow;
        return this;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public DBCluster withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        return this;
    }

    public List<DBClusterMember> getDBClusterMembers() {
        if (this.dBClusterMembers == null) {
            this.dBClusterMembers = new ListWithAutoConstructFlag();
            this.dBClusterMembers.setAutoConstruct(true);
        }
        return this.dBClusterMembers;
    }

    public void setDBClusterMembers(Collection<DBClusterMember> dBClusterMembers) {
        if (dBClusterMembers == null) {
            this.dBClusterMembers = null;
            return;
        }
        ListWithAutoConstructFlag dBClusterMembersCopy = new ListWithAutoConstructFlag(dBClusterMembers.size());
        dBClusterMembersCopy.addAll(dBClusterMembers);
        this.dBClusterMembers = dBClusterMembersCopy;
    }

    public DBCluster withDBClusterMembers(DBClusterMember ... dBClusterMembers) {
        if (this.getDBClusterMembers() == null) {
            this.setDBClusterMembers(new ArrayList<DBClusterMember>(dBClusterMembers.length));
        }
        for (DBClusterMember value : dBClusterMembers) {
            this.getDBClusterMembers().add(value);
        }
        return this;
    }

    public DBCluster withDBClusterMembers(Collection<DBClusterMember> dBClusterMembers) {
        if (dBClusterMembers == null) {
            this.dBClusterMembers = null;
        } else {
            ListWithAutoConstructFlag dBClusterMembersCopy = new ListWithAutoConstructFlag(dBClusterMembers.size());
            dBClusterMembersCopy.addAll(dBClusterMembers);
            this.dBClusterMembers = dBClusterMembersCopy;
        }
        return this;
    }

    public List<VpcSecurityGroupMembership> getVpcSecurityGroups() {
        if (this.vpcSecurityGroups == null) {
            this.vpcSecurityGroups = new ListWithAutoConstructFlag();
            this.vpcSecurityGroups.setAutoConstruct(true);
        }
        return this.vpcSecurityGroups;
    }

    public void setVpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
        if (vpcSecurityGroups == null) {
            this.vpcSecurityGroups = null;
            return;
        }
        ListWithAutoConstructFlag vpcSecurityGroupsCopy = new ListWithAutoConstructFlag(vpcSecurityGroups.size());
        vpcSecurityGroupsCopy.addAll(vpcSecurityGroups);
        this.vpcSecurityGroups = vpcSecurityGroupsCopy;
    }

    public DBCluster withVpcSecurityGroups(VpcSecurityGroupMembership ... vpcSecurityGroups) {
        if (this.getVpcSecurityGroups() == null) {
            this.setVpcSecurityGroups(new ArrayList<VpcSecurityGroupMembership>(vpcSecurityGroups.length));
        }
        for (VpcSecurityGroupMembership value : vpcSecurityGroups) {
            this.getVpcSecurityGroups().add(value);
        }
        return this;
    }

    public DBCluster withVpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
        if (vpcSecurityGroups == null) {
            this.vpcSecurityGroups = null;
        } else {
            ListWithAutoConstructFlag vpcSecurityGroupsCopy = new ListWithAutoConstructFlag(vpcSecurityGroups.size());
            vpcSecurityGroupsCopy.addAll(vpcSecurityGroups);
            this.vpcSecurityGroups = vpcSecurityGroupsCopy;
        }
        return this;
    }

    public String getHostedZoneId() {
        return this.hostedZoneId;
    }

    public void setHostedZoneId(String hostedZoneId) {
        this.hostedZoneId = hostedZoneId;
    }

    public DBCluster withHostedZoneId(String hostedZoneId) {
        this.hostedZoneId = hostedZoneId;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAllocatedStorage() != null) {
            sb.append("AllocatedStorage: " + this.getAllocatedStorage() + ",");
        }
        if (this.getAvailabilityZones() != null) {
            sb.append("AvailabilityZones: " + this.getAvailabilityZones() + ",");
        }
        if (this.getBackupRetentionPeriod() != null) {
            sb.append("BackupRetentionPeriod: " + this.getBackupRetentionPeriod() + ",");
        }
        if (this.getCharacterSetName() != null) {
            sb.append("CharacterSetName: " + this.getCharacterSetName() + ",");
        }
        if (this.getDatabaseName() != null) {
            sb.append("DatabaseName: " + this.getDatabaseName() + ",");
        }
        if (this.getDBClusterIdentifier() != null) {
            sb.append("DBClusterIdentifier: " + this.getDBClusterIdentifier() + ",");
        }
        if (this.getDBClusterParameterGroup() != null) {
            sb.append("DBClusterParameterGroup: " + this.getDBClusterParameterGroup() + ",");
        }
        if (this.getDBSubnetGroup() != null) {
            sb.append("DBSubnetGroup: " + this.getDBSubnetGroup() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getPercentProgress() != null) {
            sb.append("PercentProgress: " + this.getPercentProgress() + ",");
        }
        if (this.getEarliestRestorableTime() != null) {
            sb.append("EarliestRestorableTime: " + this.getEarliestRestorableTime() + ",");
        }
        if (this.getEndpoint() != null) {
            sb.append("Endpoint: " + this.getEndpoint() + ",");
        }
        if (this.getEngine() != null) {
            sb.append("Engine: " + this.getEngine() + ",");
        }
        if (this.getEngineVersion() != null) {
            sb.append("EngineVersion: " + this.getEngineVersion() + ",");
        }
        if (this.getLatestRestorableTime() != null) {
            sb.append("LatestRestorableTime: " + this.getLatestRestorableTime() + ",");
        }
        if (this.getPort() != null) {
            sb.append("Port: " + this.getPort() + ",");
        }
        if (this.getMasterUsername() != null) {
            sb.append("MasterUsername: " + this.getMasterUsername() + ",");
        }
        if (this.getDBClusterOptionGroupMemberships() != null) {
            sb.append("DBClusterOptionGroupMemberships: " + this.getDBClusterOptionGroupMemberships() + ",");
        }
        if (this.getPreferredBackupWindow() != null) {
            sb.append("PreferredBackupWindow: " + this.getPreferredBackupWindow() + ",");
        }
        if (this.getPreferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: " + this.getPreferredMaintenanceWindow() + ",");
        }
        if (this.getDBClusterMembers() != null) {
            sb.append("DBClusterMembers: " + this.getDBClusterMembers() + ",");
        }
        if (this.getVpcSecurityGroups() != null) {
            sb.append("VpcSecurityGroups: " + this.getVpcSecurityGroups() + ",");
        }
        if (this.getHostedZoneId() != null) {
            sb.append("HostedZoneId: " + this.getHostedZoneId());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAllocatedStorage() == null ? 0 : this.getAllocatedStorage().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZones() == null ? 0 : this.getAvailabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.getBackupRetentionPeriod() == null ? 0 : this.getBackupRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getCharacterSetName() == null ? 0 : this.getCharacterSetName().hashCode());
        hashCode = 31 * hashCode + (this.getDatabaseName() == null ? 0 : this.getDatabaseName().hashCode());
        hashCode = 31 * hashCode + (this.getDBClusterIdentifier() == null ? 0 : this.getDBClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getDBClusterParameterGroup() == null ? 0 : this.getDBClusterParameterGroup().hashCode());
        hashCode = 31 * hashCode + (this.getDBSubnetGroup() == null ? 0 : this.getDBSubnetGroup().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getPercentProgress() == null ? 0 : this.getPercentProgress().hashCode());
        hashCode = 31 * hashCode + (this.getEarliestRestorableTime() == null ? 0 : this.getEarliestRestorableTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndpoint() == null ? 0 : this.getEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getEngine() == null ? 0 : this.getEngine().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getLatestRestorableTime() == null ? 0 : this.getLatestRestorableTime().hashCode());
        hashCode = 31 * hashCode + (this.getPort() == null ? 0 : this.getPort().hashCode());
        hashCode = 31 * hashCode + (this.getMasterUsername() == null ? 0 : this.getMasterUsername().hashCode());
        hashCode = 31 * hashCode + (this.getDBClusterOptionGroupMemberships() == null ? 0 : this.getDBClusterOptionGroupMemberships().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredBackupWindow() == null ? 0 : this.getPreferredBackupWindow().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredMaintenanceWindow() == null ? 0 : this.getPreferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.getDBClusterMembers() == null ? 0 : this.getDBClusterMembers().hashCode());
        hashCode = 31 * hashCode + (this.getVpcSecurityGroups() == null ? 0 : this.getVpcSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getHostedZoneId() == null ? 0 : this.getHostedZoneId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBCluster)) {
            return false;
        }
        DBCluster other = (DBCluster)obj;
        if (other.getAllocatedStorage() == null ^ this.getAllocatedStorage() == null) {
            return false;
        }
        if (other.getAllocatedStorage() != null && !other.getAllocatedStorage().equals(this.getAllocatedStorage())) {
            return false;
        }
        if (other.getAvailabilityZones() == null ^ this.getAvailabilityZones() == null) {
            return false;
        }
        if (other.getAvailabilityZones() != null && !other.getAvailabilityZones().equals(this.getAvailabilityZones())) {
            return false;
        }
        if (other.getBackupRetentionPeriod() == null ^ this.getBackupRetentionPeriod() == null) {
            return false;
        }
        if (other.getBackupRetentionPeriod() != null && !other.getBackupRetentionPeriod().equals(this.getBackupRetentionPeriod())) {
            return false;
        }
        if (other.getCharacterSetName() == null ^ this.getCharacterSetName() == null) {
            return false;
        }
        if (other.getCharacterSetName() != null && !other.getCharacterSetName().equals(this.getCharacterSetName())) {
            return false;
        }
        if (other.getDatabaseName() == null ^ this.getDatabaseName() == null) {
            return false;
        }
        if (other.getDatabaseName() != null && !other.getDatabaseName().equals(this.getDatabaseName())) {
            return false;
        }
        if (other.getDBClusterIdentifier() == null ^ this.getDBClusterIdentifier() == null) {
            return false;
        }
        if (other.getDBClusterIdentifier() != null && !other.getDBClusterIdentifier().equals(this.getDBClusterIdentifier())) {
            return false;
        }
        if (other.getDBClusterParameterGroup() == null ^ this.getDBClusterParameterGroup() == null) {
            return false;
        }
        if (other.getDBClusterParameterGroup() != null && !other.getDBClusterParameterGroup().equals(this.getDBClusterParameterGroup())) {
            return false;
        }
        if (other.getDBSubnetGroup() == null ^ this.getDBSubnetGroup() == null) {
            return false;
        }
        if (other.getDBSubnetGroup() != null && !other.getDBSubnetGroup().equals(this.getDBSubnetGroup())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getPercentProgress() == null ^ this.getPercentProgress() == null) {
            return false;
        }
        if (other.getPercentProgress() != null && !other.getPercentProgress().equals(this.getPercentProgress())) {
            return false;
        }
        if (other.getEarliestRestorableTime() == null ^ this.getEarliestRestorableTime() == null) {
            return false;
        }
        if (other.getEarliestRestorableTime() != null && !other.getEarliestRestorableTime().equals(this.getEarliestRestorableTime())) {
            return false;
        }
        if (other.getEndpoint() == null ^ this.getEndpoint() == null) {
            return false;
        }
        if (other.getEndpoint() != null && !other.getEndpoint().equals(this.getEndpoint())) {
            return false;
        }
        if (other.getEngine() == null ^ this.getEngine() == null) {
            return false;
        }
        if (other.getEngine() != null && !other.getEngine().equals(this.getEngine())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.getLatestRestorableTime() == null ^ this.getLatestRestorableTime() == null) {
            return false;
        }
        if (other.getLatestRestorableTime() != null && !other.getLatestRestorableTime().equals(this.getLatestRestorableTime())) {
            return false;
        }
        if (other.getPort() == null ^ this.getPort() == null) {
            return false;
        }
        if (other.getPort() != null && !other.getPort().equals(this.getPort())) {
            return false;
        }
        if (other.getMasterUsername() == null ^ this.getMasterUsername() == null) {
            return false;
        }
        if (other.getMasterUsername() != null && !other.getMasterUsername().equals(this.getMasterUsername())) {
            return false;
        }
        if (other.getDBClusterOptionGroupMemberships() == null ^ this.getDBClusterOptionGroupMemberships() == null) {
            return false;
        }
        if (other.getDBClusterOptionGroupMemberships() != null && !other.getDBClusterOptionGroupMemberships().equals(this.getDBClusterOptionGroupMemberships())) {
            return false;
        }
        if (other.getPreferredBackupWindow() == null ^ this.getPreferredBackupWindow() == null) {
            return false;
        }
        if (other.getPreferredBackupWindow() != null && !other.getPreferredBackupWindow().equals(this.getPreferredBackupWindow())) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() == null ^ this.getPreferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() != null && !other.getPreferredMaintenanceWindow().equals(this.getPreferredMaintenanceWindow())) {
            return false;
        }
        if (other.getDBClusterMembers() == null ^ this.getDBClusterMembers() == null) {
            return false;
        }
        if (other.getDBClusterMembers() != null && !other.getDBClusterMembers().equals(this.getDBClusterMembers())) {
            return false;
        }
        if (other.getVpcSecurityGroups() == null ^ this.getVpcSecurityGroups() == null) {
            return false;
        }
        if (other.getVpcSecurityGroups() != null && !other.getVpcSecurityGroups().equals(this.getVpcSecurityGroups())) {
            return false;
        }
        if (other.getHostedZoneId() == null ^ this.getHostedZoneId() == null) {
            return false;
        }
        return other.getHostedZoneId() == null || other.getHostedZoneId().equals(this.getHostedZoneId());
    }

    public DBCluster clone() {
        try {
            return (DBCluster)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

