/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.kinesisfirehose.model.DeliveryStreamDescription;
import com.amazonaws.services.kinesisfirehose.model.DestinationDescription;
import com.amazonaws.services.kinesisfirehose.model.transform.DestinationDescriptionJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class DeliveryStreamDescriptionJsonMarshaller {
    private static DeliveryStreamDescriptionJsonMarshaller instance;

    public void marshall(DeliveryStreamDescription deliveryStreamDescription, JSONWriter jsonWriter) {
        if (deliveryStreamDescription == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<DestinationDescription> destinationsList;
            jsonWriter.object();
            if (deliveryStreamDescription.getDeliveryStreamName() != null) {
                jsonWriter.key("DeliveryStreamName").value(deliveryStreamDescription.getDeliveryStreamName());
            }
            if (deliveryStreamDescription.getDeliveryStreamARN() != null) {
                jsonWriter.key("DeliveryStreamARN").value(deliveryStreamDescription.getDeliveryStreamARN());
            }
            if (deliveryStreamDescription.getDeliveryStreamStatus() != null) {
                jsonWriter.key("DeliveryStreamStatus").value(deliveryStreamDescription.getDeliveryStreamStatus());
            }
            if (deliveryStreamDescription.getVersionId() != null) {
                jsonWriter.key("VersionId").value(deliveryStreamDescription.getVersionId());
            }
            if (deliveryStreamDescription.getCreateTimestamp() != null) {
                jsonWriter.key("CreateTimestamp").value(deliveryStreamDescription.getCreateTimestamp());
            }
            if (deliveryStreamDescription.getLastUpdateTimestamp() != null) {
                jsonWriter.key("LastUpdateTimestamp").value(deliveryStreamDescription.getLastUpdateTimestamp());
            }
            if ((destinationsList = deliveryStreamDescription.getDestinations()) != null) {
                jsonWriter.key("Destinations");
                jsonWriter.array();
                for (DestinationDescription destinationsListValue : destinationsList) {
                    if (destinationsListValue == null) continue;
                    DestinationDescriptionJsonMarshaller.getInstance().marshall(destinationsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (deliveryStreamDescription.getHasMoreDestinations() != null) {
                jsonWriter.key("HasMoreDestinations").value(deliveryStreamDescription.getHasMoreDestinations());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DeliveryStreamDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DeliveryStreamDescriptionJsonMarshaller();
        }
        return instance;
    }
}

