/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ConditionJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;

public class ScanRequestMarshaller
implements Marshaller<Request<ScanRequest>, ScanRequest> {
    @Override
    public Request<ScanRequest> marshall(ScanRequest scanRequest) {
        if (scanRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ScanRequest> request = new DefaultRequest<ScanRequest>(scanRequest, "AmazonDynamoDBv2");
        request.addHeader("X-Amz-Target", "DynamoDB_20120810.Scan");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Map<String, AttributeValue> expressionAttributeValuesMap;
            Map<String, String> expressionAttributeNamesMap;
            Map<String, AttributeValue> exclusiveStartKeyMap;
            Map<String, Condition> scanFilterMap;
            List<String> attributesToGetList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (scanRequest.getTableName() != null) {
                jsonWriter.key("TableName").value(scanRequest.getTableName());
            }
            if (scanRequest.getIndexName() != null) {
                jsonWriter.key("IndexName").value(scanRequest.getIndexName());
            }
            if ((attributesToGetList = scanRequest.getAttributesToGet()) != null) {
                jsonWriter.key("AttributesToGet");
                jsonWriter.array();
                for (String attributesToGetListValue : attributesToGetList) {
                    if (attributesToGetListValue == null) continue;
                    jsonWriter.value(attributesToGetListValue);
                }
                jsonWriter.endArray();
            }
            if (scanRequest.getLimit() != null) {
                jsonWriter.key("Limit").value(scanRequest.getLimit());
            }
            if (scanRequest.getSelect() != null) {
                jsonWriter.key("Select").value(scanRequest.getSelect());
            }
            if ((scanFilterMap = scanRequest.getScanFilter()) != null) {
                jsonWriter.key("ScanFilter");
                jsonWriter.object();
                for (Map.Entry<String, Condition> scanFilterMapValue : scanFilterMap.entrySet()) {
                    if (scanFilterMapValue.getValue() == null) continue;
                    jsonWriter.key(scanFilterMapValue.getKey());
                    ConditionJsonMarshaller.getInstance().marshall(scanFilterMapValue.getValue(), jsonWriter);
                }
                jsonWriter.endObject();
            }
            if (scanRequest.getConditionalOperator() != null) {
                jsonWriter.key("ConditionalOperator").value(scanRequest.getConditionalOperator());
            }
            if ((exclusiveStartKeyMap = scanRequest.getExclusiveStartKey()) != null) {
                jsonWriter.key("ExclusiveStartKey");
                jsonWriter.object();
                for (Map.Entry<String, AttributeValue> exclusiveStartKeyMapValue : exclusiveStartKeyMap.entrySet()) {
                    if (exclusiveStartKeyMapValue.getValue() == null) continue;
                    jsonWriter.key(exclusiveStartKeyMapValue.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(exclusiveStartKeyMapValue.getValue(), jsonWriter);
                }
                jsonWriter.endObject();
            }
            if (scanRequest.getReturnConsumedCapacity() != null) {
                jsonWriter.key("ReturnConsumedCapacity").value(scanRequest.getReturnConsumedCapacity());
            }
            if (scanRequest.getTotalSegments() != null) {
                jsonWriter.key("TotalSegments").value(scanRequest.getTotalSegments());
            }
            if (scanRequest.getSegment() != null) {
                jsonWriter.key("Segment").value(scanRequest.getSegment());
            }
            if (scanRequest.getProjectionExpression() != null) {
                jsonWriter.key("ProjectionExpression").value(scanRequest.getProjectionExpression());
            }
            if (scanRequest.getFilterExpression() != null) {
                jsonWriter.key("FilterExpression").value(scanRequest.getFilterExpression());
            }
            if ((expressionAttributeNamesMap = scanRequest.getExpressionAttributeNames()) != null) {
                jsonWriter.key("ExpressionAttributeNames");
                jsonWriter.object();
                for (Map.Entry<String, String> expressionAttributeNamesMapValue : expressionAttributeNamesMap.entrySet()) {
                    if (expressionAttributeNamesMapValue.getValue() == null) continue;
                    jsonWriter.key(expressionAttributeNamesMapValue.getKey());
                    jsonWriter.value(expressionAttributeNamesMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if ((expressionAttributeValuesMap = scanRequest.getExpressionAttributeValues()) != null) {
                jsonWriter.key("ExpressionAttributeValues");
                jsonWriter.object();
                for (Map.Entry<String, AttributeValue> expressionAttributeValuesMapValue : expressionAttributeValuesMap.entrySet()) {
                    if (expressionAttributeValuesMapValue.getValue() == null) continue;
                    jsonWriter.key(expressionAttributeValuesMapValue.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(expressionAttributeValuesMapValue.getValue(), jsonWriter);
                }
                jsonWriter.endObject();
            }
            if (scanRequest.getConsistentRead() != null) {
                jsonWriter.key("ConsistentRead").value(scanRequest.getConsistentRead());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

