/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.DeleteStageRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DeleteStageRequestMarshaller
implements Marshaller<Request<DeleteStageRequest>, DeleteStageRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<DeleteStageRequest> marshall(DeleteStageRequest deleteStageRequest) {
        if (deleteStageRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteStageRequest> request = new DefaultRequest<DeleteStageRequest>(deleteStageRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/restapis/{restapi_id}/stages/{stage_name}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", deleteStageRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(deleteStageRequest.getRestApiId()));
        uriResourcePath = uriResourcePath.replace("{stage_name}", deleteStageRequest.getStageName() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(deleteStageRequest.getStageName()));
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

