/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.CreateStageRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.Map;

public class CreateStageRequestMarshaller
implements Marshaller<Request<CreateStageRequest>, CreateStageRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<CreateStageRequest> marshall(CreateStageRequest createStageRequest) {
        if (createStageRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateStageRequest> request = new DefaultRequest<CreateStageRequest>(createStageRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/restapis/{restapi_id}/stages";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", createStageRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(createStageRequest.getRestApiId()));
        request.setResourcePath(uriResourcePath);
        try {
            Map<String, String> variablesMap;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createStageRequest.getStageName() != null) {
                jsonWriter.key("stageName").value(createStageRequest.getStageName());
            }
            if (createStageRequest.getDeploymentId() != null) {
                jsonWriter.key("deploymentId").value(createStageRequest.getDeploymentId());
            }
            if (createStageRequest.getDescription() != null) {
                jsonWriter.key("description").value(createStageRequest.getDescription());
            }
            if (createStageRequest.getCacheClusterEnabled() != null) {
                jsonWriter.key("cacheClusterEnabled").value(createStageRequest.getCacheClusterEnabled());
            }
            if (createStageRequest.getCacheClusterSize() != null) {
                jsonWriter.key("cacheClusterSize").value(createStageRequest.getCacheClusterSize());
            }
            if ((variablesMap = createStageRequest.getVariables()) != null) {
                jsonWriter.key("variables");
                jsonWriter.object();
                for (Map.Entry<String, String> variablesMapValue : variablesMap.entrySet()) {
                    if (variablesMapValue.getValue() == null) continue;
                    jsonWriter.key(variablesMapValue.getKey());
                    jsonWriter.value(variablesMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

