/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ecs.model.RunTaskRequest;
import com.amazonaws.services.ecs.model.transform.TaskOverrideJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class RunTaskRequestMarshaller
implements Marshaller<Request<RunTaskRequest>, RunTaskRequest> {
    @Override
    public Request<RunTaskRequest> marshall(RunTaskRequest runTaskRequest) {
        if (runTaskRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RunTaskRequest> request = new DefaultRequest<RunTaskRequest>(runTaskRequest, "AmazonECS");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerServiceV20141113.RunTask");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (runTaskRequest.getCluster() != null) {
                jsonWriter.key("cluster").value(runTaskRequest.getCluster());
            }
            if (runTaskRequest.getTaskDefinition() != null) {
                jsonWriter.key("taskDefinition").value(runTaskRequest.getTaskDefinition());
            }
            if (runTaskRequest.getOverrides() != null) {
                jsonWriter.key("overrides");
                TaskOverrideJsonMarshaller.getInstance().marshall(runTaskRequest.getOverrides(), jsonWriter);
            }
            if (runTaskRequest.getCount() != null) {
                jsonWriter.key("count").value(runTaskRequest.getCount());
            }
            if (runTaskRequest.getStartedBy() != null) {
                jsonWriter.key("startedBy").value(runTaskRequest.getStartedBy());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

